/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jtstest.testbuilder.geom.GeometryLocation;

public class GeometryPointLocater {
    private Geometry geom;
    private Coordinate locationPt;
    private int segIndex = -1;
    private boolean isVertex = false;

    public static GeometryLocation locateNonVertexPoint(Geometry geometry, Coordinate coordinate, double d) {
        GeometryPointLocater geometryPointLocater = new GeometryPointLocater(geometry);
        GeometryLocation geometryLocation = geometryPointLocater.getLocation(coordinate, d);
        if (geometryLocation == null) {
            return null;
        }
        if (geometryLocation.isVertex()) {
            return null;
        }
        return geometryLocation;
    }

    public static GeometryLocation locateVertex(Geometry geometry, Coordinate coordinate, double d) {
        GeometryPointLocater geometryPointLocater = new GeometryPointLocater(geometry);
        GeometryLocation geometryLocation = geometryPointLocater.getLocation(coordinate, d);
        if (geometryLocation == null) {
            return null;
        }
        if (geometryLocation.isVertex()) {
            return geometryLocation;
        }
        return null;
    }

    public GeometryPointLocater(Geometry geometry) {
        this.geom = geometry;
    }

    public GeometryLocation getLocation(Coordinate coordinate, double d) {
        NearestSegmentLocationFilter nearestSegmentLocationFilter = new NearestSegmentLocationFilter(coordinate, d);
        this.geom.apply((GeometryComponentFilter)nearestSegmentLocationFilter);
        this.locationPt = nearestSegmentLocationFilter.getCoordinate();
        this.segIndex = nearestSegmentLocationFilter.getIndex();
        this.isVertex = nearestSegmentLocationFilter.isVertex();
        if (this.locationPt == null) {
            return null;
        }
        return new GeometryLocation(this.geom, nearestSegmentLocationFilter.getComponent(), nearestSegmentLocationFilter.getIndex(), nearestSegmentLocationFilter.isVertex(), nearestSegmentLocationFilter.getCoordinate());
    }

    public int getIndex() {
        return this.segIndex;
    }

    public boolean isVertex() {
        return this.isVertex;
    }

    static class NearestSegmentLocationFilter
    implements GeometryComponentFilter {
        private double tolerance = 0.0;
        private Coordinate testPt;
        private Geometry component = null;
        private int segIndex = -1;
        private Coordinate nearestPt = null;
        private boolean isVertex = false;
        private LineSegment seg = new LineSegment();

        public NearestSegmentLocationFilter(Coordinate coordinate, double d) {
            this.testPt = coordinate;
            this.tolerance = d;
        }

        public void filter(Geometry geometry) {
            if (!(geometry instanceof LineString)) {
                return;
            }
            if (this.nearestPt != null) {
                return;
            }
            LineString lineString = (LineString)geometry;
            CoordinateSequence coordinateSequence = lineString.getCoordinateSequence();
            for (int i = 0; i < coordinateSequence.size(); ++i) {
                if (i != coordinateSequence.size() - 1) {
                    this.checkSegment(lineString, coordinateSequence, i);
                } else {
                    this.checkVertex(lineString, coordinateSequence, i);
                }
                if (this.nearestPt == null) continue;
                this.component = lineString;
                break;
            }
        }

        private void checkSegment(LineString lineString, CoordinateSequence coordinateSequence, int n) {
            Coordinate coordinate = coordinateSequence.getCoordinate(n);
            Coordinate coordinate2 = coordinateSequence.getCoordinate(n + 1);
            double d = coordinate.distance(this.testPt);
            double d2 = coordinate2.distance(this.testPt);
            if (d < this.tolerance) {
                this.nearestPt = coordinate;
                this.segIndex = n;
                this.isVertex = true;
            } else if (d2 < this.tolerance) {
                this.nearestPt = coordinate2;
                this.segIndex = n + 1;
                this.isVertex = true;
            } else {
                this.seg.p0 = coordinate;
                this.seg.p1 = coordinate2;
                double d3 = this.seg.distance(this.testPt);
                if (d3 < this.tolerance) {
                    this.nearestPt = this.seg.closestPoint(this.testPt);
                    this.segIndex = n;
                    this.isVertex = false;
                }
            }
        }

        private void checkVertex(LineString lineString, CoordinateSequence coordinateSequence, int n) {
            Coordinate coordinate = coordinateSequence.getCoordinate(n);
            double d = coordinate.distance(this.testPt);
            if (d < this.tolerance) {
                this.nearestPt = coordinate;
                this.segIndex = n;
                this.isVertex = true;
            }
        }

        public Geometry getComponent() {
            return this.component;
        }

        public Coordinate getCoordinate() {
            return this.nearestPt;
        }

        public int getIndex() {
            return this.segIndex;
        }

        public boolean isVertex() {
            return this.isVertex;
        }

        public boolean isDone() {
            return this.nearestPt != null;
        }

        public boolean isGeometryChanged() {
            return false;
        }
    }
}

