/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.util.GeometryEditor;

public class GeometryVertexInserter {
    public static Geometry insert(Geometry geometry, LineString lineString, int n, Coordinate coordinate) {
        GeometryEditor geometryEditor = new GeometryEditor();
        return geometryEditor.edit(geometry, (GeometryEditor.GeometryEditorOperation)new InsertVertexOperation(lineString, n, coordinate));
    }

    private static class InsertVertexOperation
    extends GeometryEditor.CoordinateOperation {
        private LineString line;
        private int segIndex;
        private Coordinate newVertex;

        public InsertVertexOperation(LineString lineString, int n, Coordinate coordinate) {
            this.line = lineString;
            this.segIndex = n;
            this.newVertex = coordinate;
        }

        public Coordinate[] edit(Coordinate[] coordinateArray, Geometry geometry) {
            if (geometry != this.line) {
                return coordinateArray;
            }
            Coordinate[] coordinateArray2 = new Coordinate[coordinateArray.length + 1];
            for (int i = 0; i < coordinateArray.length; ++i) {
                int n = i > this.segIndex ? i + 1 : i;
                coordinateArray2[n] = (Coordinate)coordinateArray[i].clone();
            }
            coordinateArray2[this.segIndex + 1] = (Coordinate)this.newVertex.clone();
            return coordinateArray2;
        }
    }
}

