/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testrunner;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.testrunner.EqualityResultMatcher;
import com.vividsolutions.jtstest.testrunner.GeometryResult;
import com.vividsolutions.jtstest.testrunner.Result;
import com.vividsolutions.jtstest.testrunner.ResultMatcher;

public class BufferResultMatcher
implements ResultMatcher {
    private ResultMatcher defaultMatcher = new EqualityResultMatcher();
    private static final double MAX_RELATIVE_AREA_DIFFERENCE = 0.001;

    public boolean isMatch(Geometry geometry, String string, Object[] objectArray, Result result, Result result2, double d) {
        if (!string.equalsIgnoreCase("buffer")) {
            return this.defaultMatcher.isMatch(geometry, string, objectArray, result, result2, d);
        }
        double d2 = Double.parseDouble((String)objectArray[0]);
        return this.isBufferResultMatch(((GeometryResult)result).getGeometry(), ((GeometryResult)result2).getGeometry(), d2);
    }

    public boolean isBufferResultMatch(Geometry geometry, Geometry geometry2, double d) {
        return this.isSymDiffAreaInTolerance(geometry, geometry2);
    }

    public boolean isSymDiffAreaInTolerance(Geometry geometry, Geometry geometry2) {
        double d = geometry2.getArea();
        Geometry geometry3 = geometry.symDifference(geometry2);
        double d2 = geometry3.getArea();
        if (d2 <= 0.0) {
            return true;
        }
        double d3 = Double.POSITIVE_INFINITY;
        if (d > 0.0) {
            d3 = d2 / d;
        }
        return d3 < 0.001;
    }
}

