/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.gml2.GMLReader;

public class MultiFormatReader {
    private static final int MAX_CHARS_TO_CHECK = 6;
    private GeometryFactory geomFactory;
    private WKTReader wktReader;
    private WKBReader wkbReader;

    private static boolean isWKB(String string) {
        return MultiFormatReader.isHex(string, 6);
    }

    private static boolean isGML(String string) {
        return string.indexOf("<") >= 0;
    }

    private static boolean isHex(String string, int n) {
        for (int i = 0; i < n && i < string.length(); ++i) {
            char c = string.charAt(i);
            if (MultiFormatReader.isHexDigit(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isHexDigit(char c) {
        if (Character.isDigit(c)) {
            return true;
        }
        char c2 = Character.toLowerCase(c);
        return c2 >= 'a' && c2 <= 'f';
    }

    public MultiFormatReader() {
        this(new GeometryFactory());
    }

    public MultiFormatReader(GeometryFactory geometryFactory) {
        this.wktReader = new WKTReader(geometryFactory);
        this.wkbReader = new WKBReader(geometryFactory);
    }

    public Geometry read(String string) throws ParseException {
        String string2 = string.trim();
        if (MultiFormatReader.isWKB(string2)) {
            return this.wkbReader.read(WKBReader.hexToBytes((String)string2));
        }
        if (MultiFormatReader.isGML(string2)) {
            return this.readGML(string2);
        }
        return this.wktReader.read(string2);
    }

    private Geometry readGML(String string) throws ParseException {
        try {
            return new GMLReader().read(string, this.geomFactory);
        }
        catch (Exception exception) {
            throw new ParseException(exception.getMessage());
        }
    }
}

