/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate;

import com.vividsolutions.jts.triangulate.quadedge.QuadEdge;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdgeSubdivision;
import com.vividsolutions.jts.triangulate.quadedge.Vertex;
import java.util.Collection;
import java.util.Iterator;

public class IncrementalDelaunayTriangulator {
    private QuadEdgeSubdivision subdiv;
    private boolean isUsingTolerance = false;

    public IncrementalDelaunayTriangulator(QuadEdgeSubdivision subdiv) {
        this.subdiv = subdiv;
        this.isUsingTolerance = subdiv.getTolerance() > 0.0;
    }

    public void insertSites(Collection vertices) {
        Iterator i = vertices.iterator();
        while (i.hasNext()) {
            Vertex v = (Vertex)i.next();
            this.insertSite(v);
        }
    }

    public QuadEdge insertSite(Vertex v) {
        QuadEdge e = this.subdiv.locate(v);
        if (this.subdiv.isVertexOfEdge(e, v)) {
            return e;
        }
        if (this.subdiv.isOnEdge(e, v.getCoordinate())) {
            e = e.oPrev();
            this.subdiv.delete(e.oNext());
        }
        QuadEdge base = this.subdiv.makeEdge(e.orig(), v);
        QuadEdge.splice(base, e);
        QuadEdge startEdge = base;
        while ((e = (base = this.subdiv.connect(e, base.sym())).oPrev()).lNext() != startEdge) {
        }
        while (true) {
            QuadEdge t;
            if ((t = e.oPrev()).dest().rightOf(e) && v.inCircle(e.orig(), t.dest(), e.dest())) {
                QuadEdge.swap(e);
                e = e.oPrev();
                continue;
            }
            if (e.oNext() == startEdge) {
                return base;
            }
            e = e.oNext().lPrev();
        }
    }
}

