/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.function;

import com.vividsolutions.jts.algorithm.MinimumBoundingCircle;
import com.vividsolutions.jts.algorithm.MinimumDiameter;
import com.vividsolutions.jts.densify.Densifier;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.OctagonalEnvelope;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.operation.linemerge.LineMerger;
import java.util.Collection;
import java.util.List;

public class ConstructionFunctions {
    public static Geometry octagonalEnvelope(Geometry geometry) {
        OctagonalEnvelope octagonalEnvelope = new OctagonalEnvelope(geometry);
        return octagonalEnvelope.toGeometry(geometry.getFactory());
    }

    public static Geometry minimumDiameter(Geometry geometry) {
        return new MinimumDiameter(geometry).getDiameter();
    }

    public static Geometry minimumRectangle(Geometry geometry) {
        return new MinimumDiameter(geometry).getMinimumRectangle();
    }

    public static Geometry minimumBoundingCircle(Geometry geometry) {
        return new MinimumBoundingCircle(geometry).getCircle();
    }

    public static Geometry boundary(Geometry geometry) {
        return geometry.getBoundary();
    }

    public static Geometry convexHull(Geometry geometry) {
        return geometry.convexHull();
    }

    public static Geometry centroid(Geometry geometry) {
        return geometry.getCentroid();
    }

    public static Geometry interiorPoint(Geometry geometry) {
        return geometry.getInteriorPoint();
    }

    public static Geometry densify(Geometry geometry, double d) {
        return Densifier.densify((Geometry)geometry, (double)d);
    }

    public static Geometry mergeLines(Geometry geometry) {
        LineMerger lineMerger = new LineMerger();
        lineMerger.add(geometry);
        Collection collection = lineMerger.getMergedLineStrings();
        return geometry.getFactory().buildGeometry(collection);
    }

    public static Geometry extractLines(Geometry geometry) {
        List list = LinearComponentExtracter.getLines((Geometry)geometry);
        return geometry.getFactory().buildGeometry((Collection)list);
    }
}

