/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jtstest.testrunner.GuiUtil;
import com.vividsolutions.jtstest.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.Timer;

public class BusyDialog
extends JDialog {
    private static Frame owner = null;
    private Executable executable;
    private Thread thread = null;
    private String description;
    private ImageIcon icon = new ImageIcon(this.getClass().getResource("Hourglass.gif"));
    private Exception exception = null;
    private String stackTrace = null;
    private Timer timer = new Timer(250, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            BusyDialog.this.label.setText(BusyDialog.this.description);
            if (!BusyDialog.this.thread.isAlive()) {
                BusyDialog.this.timer.stop();
                BusyDialog.this.setVisible(false);
            }
        }
    });
    JLabel label = new JLabel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public static void setOwner(Frame frame) {
        owner = frame;
    }

    public BusyDialog() {
        super(owner, "Busy", true);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private void jbInit() throws Exception {
        this.label.setText("Please wait . . .");
        this.label.setMaximumSize(new Dimension(400, 40));
        this.label.setMinimumSize(new Dimension(400, 40));
        this.label.setPreferredSize(new Dimension(400, 40));
        this.label.setHorizontalAlignment(0);
        this.label.setIcon(this.icon);
        this.setResizable(false);
        this.setModal(true);
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                BusyDialog.this.this_windowOpened(windowEvent);
            }
        });
        this.setDefaultCloseOperation(0);
        this.getContentPane().add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
    }

    public void execute(String string, Executable executable) throws Exception {
        this.executable = executable;
        this.description = string;
        this.exception = null;
        this.stackTrace = null;
        if (owner == null) {
            GuiUtil.centerOnScreen(this);
        } else {
            GuiUtil.center(this, owner);
        }
        this.setVisible(true);
        if (this.exception != null) {
            throw this.exception;
        }
    }

    void this_windowOpened(WindowEvent windowEvent) {
        this.label.setText(this.description);
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    BusyDialog.this.executable.execute();
                }
                catch (Exception exception) {
                    BusyDialog.this.exception = exception;
                    BusyDialog.this.stackTrace = StringUtil.getStackTrace(exception);
                }
            }
        };
        this.thread = new Thread(runnable);
        this.thread.start();
        this.timer.start();
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public static interface Executable {
        public void execute() throws Exception;
    }
}

