/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jtstest.clean.CleanDuplicatePoints;
import com.vividsolutions.jtstest.clean.LineStringExtracter;
import com.vividsolutions.jtstest.test.TestCaseList;
import com.vividsolutions.jtstest.test.Testable;
import com.vividsolutions.jtstest.testbuilder.InfoPanel;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderMenuBar;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderToolBar;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilder_AboutBox;
import com.vividsolutions.jtstest.testbuilder.PrecisionModelDialog;
import com.vividsolutions.jtstest.testbuilder.ResultController;
import com.vividsolutions.jtstest.testbuilder.ResultValuePanel;
import com.vividsolutions.jtstest.testbuilder.ResultWKTPanel;
import com.vividsolutions.jtstest.testbuilder.SpatialFunctionPanelEvent;
import com.vividsolutions.jtstest.testbuilder.SpatialFunctionPanelListener;
import com.vividsolutions.jtstest.testbuilder.StatsPanel;
import com.vividsolutions.jtstest.testbuilder.TestCasePanel;
import com.vividsolutions.jtstest.testbuilder.TestCaseTextDialog;
import com.vividsolutions.jtstest.testbuilder.TestListPanel;
import com.vividsolutions.jtstest.testbuilder.TextViewDialog;
import com.vividsolutions.jtstest.testbuilder.WKTPanel;
import com.vividsolutions.jtstest.testbuilder.model.GeometryEvent;
import com.vividsolutions.jtstest.testbuilder.model.GeometryListener;
import com.vividsolutions.jtstest.testbuilder.model.HtmlWriter;
import com.vividsolutions.jtstest.testbuilder.model.JavaTestWriter;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import com.vividsolutions.jtstest.testbuilder.model.TestCaseEdit;
import com.vividsolutions.jtstest.testbuilder.model.XMLTestWriter;
import com.vividsolutions.jtstest.testbuilder.ui.ImageUtil;
import com.vividsolutions.jtstest.testbuilder.ui.dnd.FileDrop;
import com.vividsolutions.jtstest.testbuilder.ui.tools.EditVertexTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.InfoTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.LineStringTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.PanTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.PointTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.PolygonTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.RectangleTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.ZoomToClickTool;
import com.vividsolutions.jtstest.testrunner.GuiUtil;
import com.vividsolutions.jtstest.util.FileUtil;
import com.vividsolutions.jtstest.util.MultiFormatReader;
import com.vividsolutions.jtstest.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class JTSTestBuilderFrame
extends JFrame {
    private static JTSTestBuilderFrame singleton = null;
    private ResultController resultController = new ResultController(this);
    private JTSTestBuilderMenuBar tbMenuBar = new JTSTestBuilderMenuBar(this);
    private JTSTestBuilderToolBar tbToolBar = new JTSTestBuilderToolBar(this);
    JPanel contentPane;
    BorderLayout borderLayout1 = new BorderLayout();
    Border border4;
    JSplitPane jSplitPane1 = new JSplitPane();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    TestCasePanel testCasePanel = new TestCasePanel();
    JPanel jPanel2 = new JPanel();
    JTabbedPane inputTabbedPane = new JTabbedPane();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel testPanel = new JPanel();
    WKTPanel wktPanel = new WKTPanel();
    TestListPanel testListPanel = new TestListPanel(this);
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridLayout gridLayout1 = new GridLayout();
    ResultWKTPanel resultWKTPanel = new ResultWKTPanel();
    ResultValuePanel resultValuePanel = new ResultValuePanel();
    StatsPanel statsPanel = new StatsPanel();
    InfoPanel infoPanel = new InfoPanel();
    private ZoomToClickTool zoomInTool;
    private final ImageIcon appIcon = new ImageIcon(this.getClass().getResource("app-icon.gif"));
    private JFileChooser fileChooser = new JFileChooser();
    private JFileChooser fileAndDirectoryChooser = new JFileChooser();
    private JFileChooser directoryChooser = new JFileChooser();
    TestBuilderModel tbModel;
    private FileFilter xmlFileFilter = new FileFilter(){

        public String getDescription() {
            return "JTS Test XML File (*.xml)";
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.toString().toLowerCase().endsWith(".xml");
        }
    };
    private FileFilter javaFileFilter = new FileFilter(){

        public String getDescription() {
            return "Java File (*.java)";
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.toString().toLowerCase().endsWith(".java");
        }
    };
    private TextViewDialog textViewDlg = new TextViewDialog(this, "", true);
    private TestCaseTextDialog testCaseTextDlg = new TestCaseTextDialog(this, "", true);
    private ArrayList wktABeforePMChange = new ArrayList();
    private ArrayList wktBBeforePMChange = new ArrayList();

    public JTSTestBuilderFrame() {
        try {
            Assert.isTrue((singleton == null ? 1 : 0) != 0);
            singleton = this;
            this.enableEvents(64L);
            this.setIconImage(this.appIcon.getImage());
            this.jbInit();
            this.testCasePanel.editCtlPanel.setGridSizeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JTSTestBuilderFrame.this.setGridSizeButton_actionPerformed(actionEvent);
                }
            });
            this.testCasePanel.spatialFunctionPanel.addSpatialFunctionPanelListener(new SpatialFunctionPanelListener(){

                public void functionChanged(SpatialFunctionPanelEvent spatialFunctionPanelEvent) {
                    JTSTestBuilderFrame.this.resultController.spatialFunctionPanel_functionChanged(spatialFunctionPanelEvent);
                }
            });
            this.testCasePanel.scalarFunctionPanel.addSpatialFunctionPanelListener(new SpatialFunctionPanelListener(){

                public void functionChanged(SpatialFunctionPanelEvent spatialFunctionPanelEvent) {
                    JTSTestBuilderFrame.this.resultController.scalarFunctionPanel_functionChanged(spatialFunctionPanelEvent);
                }
            });
            this.testCasePanel.editCtlPanel.btnSetPrecisionModel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JTSTestBuilderFrame.this.precisionModelMenuItem_actionPerformed(actionEvent);
                }
            });
            Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getResource("MagnifyCursor.gif")).getImage(), new Point(16, 16), "Zoom In");
            this.zoomInTool = new ZoomToClickTool(2.0, cursor);
            this.showGeomsTab();
            this.initFileDrop(this.testCasePanel);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initFileDrop(Component component) {
        new FileDrop(component, new FileDrop.Listener(){

            public void filesDropped(File[] fileArray) {
                try {
                    JTSTestBuilderFrame.this.openXmlFilesAndDirectories(fileArray);
                }
                catch (Exception exception) {
                    JTSTestBuilderFrame.reportException(null, exception);
                }
            }
        });
    }

    public static JTSTestBuilderFrame getInstance() {
        if (singleton == null) {
            new JTSTestBuilderFrame();
        }
        return singleton;
    }

    public TestBuilderModel getModel() {
        return this.tbModel;
    }

    public void setModel(TestBuilderModel testBuilderModel) {
        this.tbModel = testBuilderModel;
        this.testCasePanel.setModel(this.tbModel);
        this.wktPanel.setModel(testBuilderModel);
        this.resultWKTPanel.setModel(testBuilderModel);
        this.resultValuePanel.setModel(testBuilderModel);
        this.statsPanel.setModel(testBuilderModel);
        testBuilderModel.getGeometryEditModel().addGeometryListener(new GeometryListener(){

            public void geometryChanged(GeometryEvent geometryEvent) {
                JTSTestBuilderFrame.this.model_geometryChanged(geometryEvent);
            }
        });
        this.testListPanel.populateList();
        this.refreshNavBar();
        this.updatePrecisionModelDescription();
    }

    public static void reportException(Component component, Exception exception) {
        JOptionPane.showMessageDialog(component, StringUtil.split(exception.toString(), 80), "Exception", 0);
        exception.printStackTrace(System.out);
    }

    public static void reportException(Exception exception) {
        JTSTestBuilderFrame.reportException(JTSTestBuilderFrame.getInstance(), exception);
    }

    public void setCurrentTestCase(TestCaseEdit testCaseEdit) {
        this.tbModel.setCurrentTestCase(testCaseEdit);
        this.refreshNavBar();
    }

    public TestCasePanel getTestCasePanel() {
        return this.testCasePanel;
    }

    public String getTestJava(TestCaseList testCaseList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < testCaseList.getList().size(); ++i) {
            stringBuffer.append(new JavaTestWriter().write((Testable)testCaseList.getList().get(i)));
        }
        return stringBuffer.toString();
    }

    public void jMenuFileExit_actionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent actionEvent) {
        JTSTestBuilder_AboutBox jTSTestBuilder_AboutBox = new JTSTestBuilder_AboutBox(this);
        Dimension dimension = jTSTestBuilder_AboutBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        jTSTestBuilder_AboutBox.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        jTSTestBuilder_AboutBox.setModal(true);
        jTSTestBuilder_AboutBox.show();
    }

    public void showGeomsTab() {
        this.inputTabbedPane.setSelectedIndex(this.inputTabbedPane.indexOfTab("Input"));
    }

    public void showResultWKTTab() {
        this.inputTabbedPane.setSelectedIndex(this.inputTabbedPane.indexOfTab("Result"));
    }

    public void showResultValueTab() {
        this.inputTabbedPane.setSelectedIndex(this.inputTabbedPane.indexOfTab("Value"));
    }

    public void showInfoTab() {
        this.inputTabbedPane.setSelectedIndex(this.inputTabbedPane.indexOfTab("Info"));
    }

    public void openXmlFilesAndDirectories(File[] fileArray) throws Exception {
        if (fileArray.length == 1) {
            this.fileChooser.setSelectedFile(fileArray[0]);
        }
        this.tbModel.openXmlFilesAndDirectories(fileArray);
        this.reportProblemsParsingXmlTestFile(this.tbModel.getParsingProblems());
        this.refreshNavBar();
        this.testListPanel.populateList();
        this.updatePrecisionModelDescription();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.jMenuFileExit_actionPerformed(null);
        }
    }

    void setGridSizeButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.testCasePanel.editPanel.setGridSize(Double.parseDouble(this.testCasePanel.editCtlPanel.txtGridSize.getText()));
        }
        catch (Exception exception) {
            JTSTestBuilderFrame.reportException(this, exception);
        }
    }

    void model_geometryChanged(GeometryEvent geometryEvent) {
        this.testCasePanel.editPanel.updateView();
        this.updateWktPanel();
    }

    void wktPanel_actionPerformed(ActionEvent actionEvent) {
        try {
            this.loadGeometryText(false);
        }
        catch (Exception exception) {
            JTSTestBuilderFrame.reportException(this, exception);
        }
    }

    void btnNewCase_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.createNew();
        this.showGeomsTab();
        this.refreshNavBar();
        this.testListPanel.populateList();
    }

    void refreshNavBar() {
        this.testCasePanel.setTestCase(this.tbModel.getCurrentTestCaseEdit());
        this.getTestCasePanel().setCurrentTestCaseIndex(this.tbModel.getCurrentTestIndex() + 1);
        this.getTestCasePanel().setMaxTestCaseIndex(this.tbModel.getTestListSize());
        this.updateWktPanel();
    }

    void btnPrevCase_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.prevCase();
        this.refreshNavBar();
    }

    void btnNextCase_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.nextCase();
        this.refreshNavBar();
    }

    void btnCopyCase_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.copyCase();
        this.refreshNavBar();
        this.testListPanel.populateList();
    }

    public void copyResultToTest() {
        Object object = this.resultWKTPanel.getResult();
        if (!(object instanceof Geometry)) {
            return;
        }
        this.tbModel.addCase(new Geometry[]{(Geometry)object, null});
        this.refreshNavBar();
        this.testListPanel.populateList();
    }

    void btnExchangeGeoms_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.getCurrentTestCaseEdit().exchange();
        this.testCasePanel.setTestCase(this.tbModel.getCurrentTestCaseEdit());
    }

    void btnDeleteCase_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.deleteCase();
        this.refreshNavBar();
        this.testListPanel.populateList();
    }

    void menuExchangeGeom_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.getCurrentTestCaseEdit().exchange();
        this.testCasePanel.setTestCase(this.tbModel.getCurrentTestCaseEdit());
    }

    void menuTestText_actionPerformed(ActionEvent actionEvent) {
        this.testCaseTextDlg.setTestCase(this.tbModel.getCurrentTestCaseEdit());
        this.testCaseTextDlg.show();
    }

    void menuLoadXmlTestFile_actionPerformed(ActionEvent actionEvent) {
        try {
            this.fileChooser.removeChoosableFileFilter(this.javaFileFilter);
            this.fileChooser.addChoosableFileFilter(this.xmlFileFilter);
            this.fileChooser.setDialogTitle("Open XML Test File(s)");
            this.fileChooser.setMultiSelectionEnabled(true);
            if (0 == this.fileChooser.showOpenDialog(this)) {
                File[] fileArray = this.fileChooser.getSelectedFiles();
                if (fileArray.length == 0) {
                    fileArray = new File[]{this.fileChooser.getSelectedFile()};
                }
                this.openXmlFilesAndDirectories(fileArray);
            }
        }
        catch (Exception exception) {
            JTSTestBuilderFrame.reportException(this, exception);
        }
    }

    void menuSaveAsXml_actionPerformed(ActionEvent actionEvent) {
        try {
            this.fileChooser.removeChoosableFileFilter(this.javaFileFilter);
            this.fileChooser.addChoosableFileFilter(this.xmlFileFilter);
            this.fileChooser.setDialogTitle("Save XML Test File");
            if (0 == this.fileChooser.showSaveDialog(this)) {
                int n;
                File file = this.fileChooser.getSelectedFile();
                if (file.exists() && (n = JOptionPane.showConfirmDialog(this, file.getName() + " exists. Overwrite?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                FileUtil.setContents(this.fileChooser.getSelectedFile().getPath(), XMLTestWriter.getRunXml(this.tbModel.getTestCaseList(), this.tbModel.getPrecisionModel()));
            }
        }
        catch (Exception exception) {
            JTSTestBuilderFrame.reportException(this, exception);
        }
    }

    public String getRunXml() {
        return XMLTestWriter.getRunXml(this.tbModel.getTestCaseList(), this.tbModel.getPrecisionModel());
    }

    void menuSaveAsJava_actionPerformed(ActionEvent actionEvent) {
        try {
            this.fileChooser.removeChoosableFileFilter(this.xmlFileFilter);
            this.fileChooser.addChoosableFileFilter(this.javaFileFilter);
            this.fileChooser.setDialogTitle("Save Java File");
            if (0 == this.fileChooser.showSaveDialog(this)) {
                int n;
                File file = this.fileChooser.getSelectedFile();
                if (file.exists() && (n = JOptionPane.showConfirmDialog(this, file.getName() + " exists. Overwrite?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                String string = this.fileChooser.getSelectedFile().getName();
                int n2 = string.lastIndexOf(".");
                if (n2 > 0) {
                    string = string.substring(0, n2);
                }
                FileUtil.setContents(this.fileChooser.getSelectedFile().getPath(), this.getRunJava(string));
            }
        }
        catch (Exception exception) {
            JTSTestBuilderFrame.reportException(this, exception);
        }
    }

    void menuSaveAsHtml_actionPerformed(ActionEvent actionEvent) {
        try {
            this.directoryChooser.setDialogTitle("Select Folder In Which To Save HTML and GIF Files");
            if (0 == this.directoryChooser.showSaveDialog(this)) {
                int n = JOptionPane.showConfirmDialog(this, "Would you like the spatial function images to show the A and B geometries?", "Confirmation", 1);
                HtmlWriter htmlWriter = new HtmlWriter();
                switch (n) {
                    case 2: {
                        return;
                    }
                    case 0: {
                        htmlWriter.setShowingABwithSpatialFunction(true);
                        break;
                    }
                    case 1: {
                        htmlWriter.setShowingABwithSpatialFunction(false);
                    }
                }
                File file = this.directoryChooser.getSelectedFile();
                Assert.isTrue((boolean)file.exists());
                htmlWriter.write(file, this.tbModel.getTestCaseList(), this.tbModel.getPrecisionModel());
            }
        }
        catch (Exception exception) {
            JTSTestBuilderFrame.reportException(this, exception);
        }
    }

    void menuSaveAsPNG_actionPerformed(ActionEvent actionEvent) {
        try {
            this.directoryChooser.setDialogTitle("Select Folder In Which To Save PNG");
            if (0 == this.directoryChooser.showSaveDialog(this)) {
                File file = this.directoryChooser.getSelectedFile();
                String string = file.getPath() + "\\" + "geoms";
                ImageUtil.writeImage(this.testCasePanel.getGeometryEditPanel(), string + ".png", ImageUtil.IMAGE_FORMAT_NAME_PNG);
            }
        }
        catch (Exception exception) {
            JTSTestBuilderFrame.reportException(this, exception);
        }
    }

    void menuSaveScreenToClipboard_actionPerformed(ActionEvent actionEvent) {
        try {
            ImageUtil.saveImageToClipboard(this.testCasePanel.getGeometryEditPanel(), ImageUtil.IMAGE_FORMAT_NAME_PNG);
        }
        catch (Exception exception) {
            JTSTestBuilderFrame.reportException(this, exception);
        }
    }

    void drawRectangleButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(RectangleTool.getInstance());
    }

    void drawPolygonButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(PolygonTool.getInstance());
    }

    void drawLineStringButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(LineStringTool.getInstance());
    }

    void drawPointButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(PointTool.getInstance());
    }

    void infoButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(InfoTool.getInstance());
    }

    void zoomInButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(this.zoomInTool);
    }

    void oneToOneButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().getViewport().zoomToInitialExtent();
    }

    void zoomToFullExtentButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().zoomToFullExtent();
    }

    void zoomToInputButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().zoomToInput();
    }

    void panButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(PanTool.getInstance());
    }

    void deleteAllTestCasesMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.initTestCaseList();
        this.refreshNavBar();
        this.testListPanel.populateList();
    }

    void showVerticesMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.setShowingVertices(this.tbMenuBar.showVerticesMenuItem.isSelected());
    }

    void showOrientationsMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.setShowingOrientations(this.tbMenuBar.showOrientationsMenuItem.isSelected());
    }

    void showGridMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.editPanel.setGridEnabled(this.tbMenuBar.showGridMenuItem.isSelected());
        this.testCasePanel.editPanel.updateView();
    }

    public void setShowingOrientations(boolean bl) {
        TestBuilderModel.setShowingOrientations(bl);
        this.testCasePanel.editPanel.updateView();
    }

    public void setShowVertexIndices(boolean bl) {
        TestBuilderModel.setShowingOrientations(bl);
        this.testCasePanel.editPanel.updateView();
    }

    public void setShowingVertices(boolean bl) {
        TestBuilderModel.setShowingVertices(bl);
        this.testCasePanel.editPanel.updateView();
    }

    void showVertexIndicesMenuItem_actionPerformed(ActionEvent actionEvent) {
    }

    void menuLoadXmlTestFolder_actionPerformed(ActionEvent actionEvent) {
        try {
            this.directoryChooser.removeChoosableFileFilter(this.javaFileFilter);
            this.directoryChooser.setDialogTitle("Open Folder(s) Containing XML Test Files");
            this.directoryChooser.setMultiSelectionEnabled(true);
            if (0 == this.directoryChooser.showOpenDialog(this)) {
                File[] fileArray = this.directoryChooser.getSelectedFiles();
                if (fileArray.length == 0) {
                    fileArray = new File[]{this.fileChooser.getSelectedFile()};
                }
                this.openXmlFilesAndDirectories(fileArray);
            }
        }
        catch (Exception exception) {
            JTSTestBuilderFrame.reportException(this, exception);
        }
    }

    void precisionModelMenuItem_actionPerformed(ActionEvent actionEvent) {
        try {
            PrecisionModelDialog precisionModelDialog = new PrecisionModelDialog(this, "Edit Precision Model", true);
            GuiUtil.center(precisionModelDialog, this);
            precisionModelDialog.setPrecisionModel(this.tbModel.getPrecisionModel());
            precisionModelDialog.setVisible(true);
            this.saveWKTBeforePMChange();
            this.tbModel.setPrecisionModel(precisionModelDialog.getPrecisionModel());
            this.loadWKTAfterPMChange();
            this.updatePrecisionModelDescription();
            this.updateGeometry();
        }
        catch (ParseException parseException) {
            JTSTestBuilderFrame.reportException(this, (Exception)((Object)parseException));
        }
    }

    void moveToOriginButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.loadGeometryText(true);
        }
        catch (Exception exception) {
            JTSTestBuilderFrame.reportException(this, exception);
        }
    }

    private String getRunJava(String string) {
        return "package com.vividsolutions.jtstest.testsuite;" + StringUtil.newLine + "" + StringUtil.newLine + "import com.vividsolutions.jtstest.test.*;" + StringUtil.newLine + "" + StringUtil.newLine + "public class " + string + " extends TestCaseList {" + StringUtil.newLine + "  public static void main(String[] args) {" + StringUtil.newLine + "    " + string + " test = new " + string + "();" + StringUtil.newLine + "    test.run();" + StringUtil.newLine + "  }" + StringUtil.newLine + "" + StringUtil.newLine + "  public " + string + "() {" + StringUtil.newLine + this.getTestJava(this.tbModel.getTestCaseList()) + "  }" + StringUtil.newLine + "}";
    }

    private void jbInit() throws Exception {
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileAndDirectoryChooser.setFileSelectionMode(2);
        this.fileAndDirectoryChooser.setMultiSelectionEnabled(true);
        this.directoryChooser.setFileSelectionMode(1);
        this.directoryChooser.setMultiSelectionEnabled(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.textViewDlg.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.textViewDlg.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.contentPane = (JPanel)this.getContentPane();
        this.border4 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(93, 93, 93), new Color(134, 134, 134));
        this.contentPane.setLayout(this.borderLayout1);
        this.setSize(new Dimension(800, 800));
        this.setTitle("JTS TestBuilder");
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setPreferredSize(new Dimension(601, 690));
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel1.setMinimumSize(new Dimension(431, 0));
        this.contentPane.setPreferredSize(new Dimension(601, 690));
        this.inputTabbedPane.setTabPlacement(2);
        this.jPanel2.setLayout(this.borderLayout3);
        this.wktPanel.setMinimumSize(new Dimension(111, 0));
        this.wktPanel.setPreferredSize(new Dimension(600, 100));
        this.wktPanel.setToolTipText("Enter WKT, WKB or GML for a geometry; or drag-n-drop a WKT or SHP file");
        this.testPanel.setLayout(this.gridBagLayout2);
        this.gridLayout1.setRows(4);
        this.gridLayout1.setColumns(1);
        this.contentPane.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.jPanel1, "top");
        this.jPanel1.add((Component)this.testCasePanel, "Center");
        this.jSplitPane1.add((Component)this.jPanel2, "bottom");
        this.jPanel2.add((Component)this.inputTabbedPane, "Center");
        this.jSplitPane1.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.jSplitPane1.setResizeWeight(0.5);
        this.inputTabbedPane.add((Component)this.testPanel, "Tests");
        this.testPanel.add((Component)this.testListPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.inputTabbedPane.add((Component)this.wktPanel, "Input");
        this.inputTabbedPane.add((Component)this.resultWKTPanel, "Result");
        this.inputTabbedPane.add((Component)this.resultValuePanel, "Value");
        this.inputTabbedPane.add((Component)this.statsPanel, "Stats");
        this.inputTabbedPane.add((Component)this.infoPanel, "Info");
        this.inputTabbedPane.setSelectedIndex(1);
        this.inputTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (JTSTestBuilderFrame.this.inputTabbedPane.getComponent(JTSTestBuilderFrame.this.inputTabbedPane.getSelectedIndex()) == JTSTestBuilderFrame.this.statsPanel) {
                    JTSTestBuilderFrame.this.statsPanel.refresh();
                }
            }
        });
        this.jSplitPane1.setDividerLocation(500);
        this.wktPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.wktPanel_actionPerformed(actionEvent);
            }
        });
        this.setJMenuBar(this.tbMenuBar.getMenuBar());
        this.contentPane.add((Component)this.tbToolBar.getToolBar(), "North");
    }

    private void updateGeometry() {
        this.testCasePanel.relatePanel.clearResults();
        this.testCasePanel.setTestCase(this.tbModel.getCurrentTestCaseEdit());
        this.updateWktPanel();
    }

    private void updateWktPanel() {
        Geometry geometry = this.tbModel.getGeometryEditModel().getGeometry(0);
        this.wktPanel.setText(geometry, 0);
        Geometry geometry2 = this.tbModel.getGeometryEditModel().getGeometry(1);
        this.wktPanel.setText(geometry2, 1);
    }

    public void displayInfo(Coordinate coordinate) {
        this.infoPanel.setInfo(this.testCasePanel.getGeometryEditPanel().getInfo(coordinate));
        this.showInfoTab();
    }

    private void reportProblemsParsingXmlTestFile(List list) {
        if (list.isEmpty()) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            System.out.println(string);
        }
        JOptionPane.showMessageDialog(this, StringUtil.split(list.size() + " problems occurred parsing the XML test file." + " The first problem was: " + list.get(0), 80), "Error", 0);
    }

    private void saveWKTBeforePMChange() {
        this.wktABeforePMChange.clear();
        this.wktBBeforePMChange.clear();
        Iterator iterator = this.tbModel.getTestCaseList().getList().iterator();
        while (iterator.hasNext()) {
            Testable testable = (Testable)iterator.next();
            Geometry geometry = testable.getGeometry(0);
            Geometry geometry2 = testable.getGeometry(1);
            this.wktABeforePMChange.add(geometry != null ? geometry.toText() : null);
            this.wktBBeforePMChange.add(geometry2 != null ? geometry2.toText() : null);
        }
    }

    private void loadWKTAfterPMChange() throws ParseException {
        WKTReader wKTReader = new WKTReader(new GeometryFactory(this.tbModel.getPrecisionModel(), 0));
        for (int i = 0; i < this.tbModel.getTestCaseList().getList().size(); ++i) {
            Testable testable = (Testable)this.tbModel.getTestCaseList().getList().get(i);
            String string = (String)this.wktABeforePMChange.get(i);
            String string2 = (String)this.wktBBeforePMChange.get(i);
            testable.setGeometry(0, string != null ? wKTReader.read(string) : null);
            testable.setGeometry(1, string2 != null ? wKTReader.read(string2) : null);
        }
    }

    private double offsetNumber(double d, Coordinate coordinate, boolean bl) {
        return d - (bl ? coordinate.x : coordinate.y);
    }

    private String offset(String string, Coordinate coordinate) throws IOException {
        String string2 = "";
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        boolean bl = false;
        int n = streamTokenizer.nextToken();
        while (n != -1) {
            string2 = string2 + " ";
            switch (n) {
                case 10: {
                    break;
                }
                case -2: {
                    bl = !bl;
                    string2 = string2 + this.offsetNumber(streamTokenizer.nval, coordinate, bl);
                    break;
                }
                case -3: {
                    string2 = string2 + streamTokenizer.sval;
                    break;
                }
                case 40: {
                    string2 = string2 + "(";
                    break;
                }
                case 41: {
                    string2 = string2 + ")";
                    break;
                }
                case 44: {
                    string2 = string2 + ",";
                    break;
                }
                default: {
                    Assert.shouldNeverReachHere();
                }
            }
            n = streamTokenizer.nextToken();
        }
        return string2;
    }

    private void loadGeometryText(boolean bl) throws ParseException, IOException {
        TestCaseEdit testCaseEdit;
        MultiFormatReader multiFormatReader = new MultiFormatReader(new GeometryFactory(this.tbModel.getPrecisionModel(), 0));
        Geometry geometry = null;
        String string = this.wktPanel.getGeometryTextClean(0);
        if (string.length() > 0) {
            geometry = multiFormatReader.read(string);
        }
        Geometry geometry2 = null;
        String string2 = this.wktPanel.getGeometryTextClean(1);
        if (string2.length() > 0) {
            geometry2 = multiFormatReader.read(string2);
        }
        if (bl) {
            testCaseEdit = this.pickOffset(geometry, geometry2);
            if (testCaseEdit == null) {
                return;
            }
            if (geometry != null) {
                geometry = multiFormatReader.read(this.offset(this.wktPanel.getGeometryTextA(), (Coordinate)testCaseEdit));
            }
            if (geometry2 != null) {
                geometry2 = multiFormatReader.read(this.offset(this.wktPanel.getGeometryTextB(), (Coordinate)testCaseEdit));
            }
        }
        testCaseEdit = this.tbModel.getCurrentTestCaseEdit();
        testCaseEdit.setGeometry(0, geometry);
        testCaseEdit.setGeometry(1, geometry2);
        this.tbModel.getGeometryEditModel().setTestCase(testCaseEdit);
    }

    private void updatePrecisionModelDescription() {
        this.testCasePanel.setPrecisionModelDescription(this.tbModel.getPrecisionModel().toString());
    }

    void menuRemoveDuplicatePoints_actionPerformed(ActionEvent actionEvent) {
        CleanDuplicatePoints cleanDuplicatePoints = new CleanDuplicatePoints();
        Geometry geometry = cleanDuplicatePoints.clean(this.tbModel.getCurrentTestCaseEdit().getGeometry(0));
        this.tbModel.getCurrentTestCaseEdit().setGeometry(0, geometry);
        this.updateGeometry();
    }

    void menuChangeToLines_actionPerformed(ActionEvent actionEvent) {
        LineStringExtracter lineStringExtracter = new LineStringExtracter();
        Geometry geometry = lineStringExtracter.extract(this.tbModel.getCurrentTestCaseEdit().getGeometry(0));
        this.tbModel.getCurrentTestCaseEdit().setGeometry(0, geometry);
        this.updateGeometry();
    }

    void btnEditVertex_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(EditVertexTool.getInstance());
    }

    private Coordinate pickOffset(Geometry geometry, Geometry geometry2) {
        if (geometry != null && !geometry.isEmpty()) {
            return geometry.getCoordinates()[0];
        }
        if (geometry2 != null && !geometry2.isEmpty()) {
            return geometry2.getCoordinates()[0];
        }
        return null;
    }
}

