/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.util.Stopwatch;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.SpatialFunctionPanelEvent;
import com.vividsolutions.jtstest.testbuilder.ui.SwingWorker;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class ResultController {
    JTSTestBuilderFrame frame;
    private SwingWorker worker = null;
    private Timer funcTimer;
    private long runMillis = 0L;
    private static final int DELAY_IN_MILLIS = 100;

    public ResultController(JTSTestBuilderFrame jTSTestBuilderFrame) {
        this.frame = jTSTestBuilderFrame;
    }

    public void spatialFunctionPanel_functionChanged(SpatialFunctionPanelEvent spatialFunctionPanelEvent) {
        String string = this.frame.testCasePanel.getSpatialFunctionPanel().getFullName();
        this.frame.resultWKTPanel.setOpName(string);
        this.clearResult();
        if (string == null) {
            return;
        }
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        this.frame.testCasePanel.getSpatialFunctionPanel().enableExecuteControl(false);
        this.startFunctionMonitor();
        this.runFunctionWorker();
        this.frame.showResultWKTTab();
    }

    private void clearResult() {
        this.frame.resultWKTPanel.clearResult();
        this.updateResult(null);
    }

    private void updateResult(Object object) {
        this.frame.resultWKTPanel.setResult(object);
        if (object == null || object instanceof Geometry) {
            this.frame.tbModel.getCurrentTestCaseEdit().setResult((Geometry)object);
        }
        this.frame.getTestCasePanel().getGeometryEditPanel().updateView();
    }

    private void runFunctionWorker() {
        this.worker = new SwingWorker(){

            public Object construct() {
                return ResultController.this.frame.testCasePanel.getSpatialFunctionPanel().getResult();
            }

            public void finished() {
                ResultController.this.stopFunctionMonitor();
                ResultController.this.frame.testCasePanel.getSpatialFunctionPanel().enableExecuteControl(true);
                Object object = this.getValue();
                ResultController.this.frame.setCursor(Cursor.getPredefinedCursor(0));
                Stopwatch stopwatch = ResultController.this.frame.testCasePanel.getSpatialFunctionPanel().getTimer();
                ResultController.this.frame.resultWKTPanel.setExecutedTime(stopwatch.getTimeString());
                ResultController.this.updateResult(object);
                ResultController.this.worker = null;
            }
        };
        this.worker.start();
    }

    private void clearFunctionWorker() {
    }

    private void startFunctionMonitor() {
        this.runMillis = 0L;
        this.funcTimer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultController.this.runMillis += 100L;
                ResultController.this.frame.resultWKTPanel.setRunningTime((double)ResultController.this.runMillis / 1000.0 + " s");
            }
        });
        this.funcTimer.setInitialDelay(0);
        this.funcTimer.start();
    }

    private void stopFunctionMonitor() {
        this.funcTimer.stop();
    }

    public void scalarFunctionPanel_functionChanged(SpatialFunctionPanelEvent spatialFunctionPanelEvent) {
        String string = this.frame.testCasePanel.getScalarFunctionPanel().getOpName();
        this.frame.resultValuePanel.setResult(string, "", null);
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        Object object = this.frame.testCasePanel.getScalarFunctionPanel().getResult();
        Stopwatch stopwatch = this.frame.testCasePanel.getScalarFunctionPanel().getTimer();
        this.frame.setCursor(Cursor.getPredefinedCursor(0));
        this.frame.resultValuePanel.setResult(string, stopwatch.getTimeString(), object);
        this.frame.showResultValueTab();
    }
}

