/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.io.gml2.GMLWriter;
import com.vividsolutions.jtstest.testbuilder.model.JavaTestWriter;
import com.vividsolutions.jtstest.testbuilder.model.TestCaseEdit;
import com.vividsolutions.jtstest.testbuilder.model.XMLTestWriter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TestCaseTextDialog
extends JDialog {
    private TestCaseEdit test;
    JPanel dialogPanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextArea txtGeomView = new JTextArea();
    JPanel jPanel1 = new JPanel();
    JPanel cmdButtonPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    JButton btnCopy = new JButton();
    JButton btnOk = new JButton();
    JPanel textFormatPanel = new JPanel();
    JPanel allOptionsPanel = new JPanel();
    JPanel functionsPanel = new JPanel();
    BoxLayout boxLayout1 = new BoxLayout(this.functionsPanel, 1);
    JRadioButton rbXML = new JRadioButton();
    JRadioButton rbTestCaseJava = new JRadioButton();
    JRadioButton rbJTSJava = new JRadioButton();
    JRadioButton rbWKB = new JRadioButton();
    ButtonGroup textFormatGroup = new ButtonGroup();
    JRadioButton rbWKT = new JRadioButton();
    JRadioButton rbWKTFormatted = new JRadioButton();
    JRadioButton rbGML = new JRadioButton();
    JCheckBox intersectsCB = new JCheckBox();

    public TestCaseTextDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public TestCaseTextDialog() {
        this((Frame)null, "", false);
    }

    void jbInit() throws Exception {
        this.dialogPanel.setLayout(this.borderLayout1);
        this.jScrollPane1.setPreferredSize(new Dimension(500, 300));
        this.txtGeomView.setLineWrap(true);
        this.jPanel1.setLayout(this.borderLayout2);
        this.btnCopy.setEnabled(true);
        this.btnCopy.setText("Copy");
        this.btnCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestCaseTextDialog.this.btnSelect_actionPerformed(actionEvent);
            }
        });
        this.btnOk.setToolTipText("");
        this.btnOk.setText("Close");
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestCaseTextDialog.this.btnOk_actionPerformed(actionEvent);
            }
        });
        this.rbXML.setText("Test XML");
        this.rbXML.setToolTipText("");
        this.rbXML.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestCaseTextDialog.this.rbXML_actionPerformed(actionEvent);
            }
        });
        this.rbTestCaseJava.setText("TestCase Java");
        this.rbTestCaseJava.setToolTipText("");
        this.rbTestCaseJava.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestCaseTextDialog.this.rbTestCaseJava_actionPerformed(actionEvent);
            }
        });
        this.rbJTSJava.setEnabled(false);
        this.rbJTSJava.setText("JTS Java ");
        this.rbWKT.setText("WKT");
        this.rbWKT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestCaseTextDialog.this.rbWKT_actionPerformed(actionEvent);
            }
        });
        this.rbWKTFormatted.setText("WKT-Formatted");
        this.rbWKTFormatted.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestCaseTextDialog.this.rbWKTFormatted_actionPerformed(actionEvent);
            }
        });
        this.rbWKB.setText("WKB");
        this.rbWKB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestCaseTextDialog.this.rbWKB_actionPerformed(actionEvent);
            }
        });
        this.rbGML.setText("GML");
        this.rbGML.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestCaseTextDialog.this.rbGML_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.dialogPanel);
        this.dialogPanel.add((Component)this.jScrollPane1, "Center");
        this.dialogPanel.add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.cmdButtonPanel, "South");
        this.cmdButtonPanel.add((Component)this.btnCopy, null);
        this.cmdButtonPanel.add((Component)this.btnOk, null);
        this.textFormatPanel.add((Component)this.rbWKT, null);
        this.textFormatPanel.add((Component)this.rbWKTFormatted, null);
        this.textFormatPanel.add((Component)this.rbWKB, null);
        this.textFormatPanel.add((Component)this.rbGML, null);
        this.textFormatPanel.add((Component)this.rbTestCaseJava, null);
        this.textFormatPanel.add((Component)this.rbXML, null);
        this.textFormatPanel.add((Component)this.rbJTSJava, null);
        this.jScrollPane1.getViewport().add((Component)this.txtGeomView, null);
        this.allOptionsPanel.setLayout(this.borderLayout3);
        this.allOptionsPanel.add((Component)this.textFormatPanel, "North");
        this.allOptionsPanel.add((Component)this.functionsPanel, "Center");
        this.jPanel1.add((Component)this.allOptionsPanel, "Center");
        this.textFormatGroup.add(this.rbJTSJava);
        this.textFormatGroup.add(this.rbTestCaseJava);
        this.textFormatGroup.add(this.rbXML);
        this.textFormatGroup.add(this.rbWKT);
        this.textFormatGroup.add(this.rbWKTFormatted);
        this.textFormatGroup.add(this.rbWKB);
        this.textFormatGroup.add(this.rbGML);
    }

    public void setTestCase(TestCaseEdit testCaseEdit) {
        this.test = testCaseEdit;
        this.rbXML.setEnabled(true);
        this.rbXML.doClick();
    }

    void btnOk_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    void btnSelect_actionPerformed(ActionEvent actionEvent) {
        this.txtGeomView.selectAll();
        this.txtGeomView.copy();
    }

    void rbTestCaseJava_actionPerformed(ActionEvent actionEvent) {
        this.txtGeomView.setText(new JavaTestWriter().write(this.test));
    }

    void rbXML_actionPerformed(ActionEvent actionEvent) {
        this.txtGeomView.setText(new XMLTestWriter().getTestXML(this.test));
    }

    void rbWKB_actionPerformed(ActionEvent actionEvent) {
        this.writeView(this.convertToWKB(this.test.getGeometry(0)), this.convertToWKB(this.test.getGeometry(1)), this.convertToWKB(this.test.getResult()));
    }

    void rbWKT_actionPerformed(ActionEvent actionEvent) {
        this.writeView(this.test.getGeometry(0) == null ? null : this.test.getGeometry(0).toString(), this.test.getGeometry(1) == null ? null : this.test.getGeometry(1).toString(), this.test.getResult() == null ? null : this.test.getResult().toString());
    }

    void rbWKTFormatted_actionPerformed(ActionEvent actionEvent) {
        this.writeView(this.convertToWKT(this.test.getGeometry(0), true), this.convertToWKT(this.test.getGeometry(1), true), this.convertToWKT(this.test.getResult(), true));
    }

    void rbGML_actionPerformed(ActionEvent actionEvent) {
        this.writeView(this.convertToGML(this.test.getGeometry(0)), this.convertToGML(this.test.getGeometry(1)), this.convertToGML(this.test.getResult()));
    }

    private void writeView(String string, String string2, String string3) {
        this.txtGeomView.setText("");
        this.writeViewGeometry("A", string);
        this.writeViewGeometry("B", string2);
        this.writeViewGeometry("Result", string3);
    }

    private void writeViewGeometry(String string, String string2) {
        if (string2 == null || string2.length() <= 0) {
            return;
        }
        this.txtGeomView.append(string + ":\n\n");
        this.txtGeomView.append(string2);
        this.txtGeomView.append("\n\n");
    }

    private String convertToWKT(Geometry geometry, boolean bl) {
        if (geometry == null) {
            return "";
        }
        if (!bl) {
            return geometry.toString();
        }
        WKTWriter wKTWriter = new WKTWriter();
        wKTWriter.setFormatted(bl);
        wKTWriter.setMaxCoordinatesPerLine(5);
        return wKTWriter.write(geometry);
    }

    private String convertToWKB(Geometry geometry) {
        if (geometry == null) {
            return "";
        }
        return WKBWriter.toHex((byte[])new WKBWriter().write(geometry));
    }

    private String convertToGML(Geometry geometry) {
        if (geometry == null) {
            return "";
        }
        return new GMLWriter().write(geometry);
    }
}

