/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jtstest.testbuilder.geom.FacetLocater;
import com.vividsolutions.jtstest.testbuilder.geom.GeometryLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class ComponentLocater {
    private Geometry parentGeom;
    private List components = new ArrayList();
    private Coordinate queryPt;
    private double tolerance = 0.0;
    private Geometry aoi;

    public ComponentLocater(Geometry geometry) {
        this.parentGeom = geometry;
    }

    public List getComponents(Coordinate coordinate, double d) {
        this.queryPt = coordinate;
        this.tolerance = d;
        this.aoi = this.createAOI(coordinate, d);
        this.findComponents(new Stack(), this.parentGeom, this.components);
        return this.components;
    }

    private Geometry createAOI(Coordinate coordinate, double d) {
        Envelope envelope = new Envelope(coordinate);
        envelope.expandBy(2.0 * d);
        return this.parentGeom.getFactory().toGeometry(envelope);
    }

    private void findComponents(Stack stack, Geometry geometry, List list) {
        if (geometry instanceof GeometryCollection) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                Geometry geometry2 = geometry.getGeometryN(i);
                stack.push(new Integer(i));
                this.findComponents(stack, geometry2, list);
                stack.pop();
            }
            return;
        }
        if (this.aoi.intersects(geometry)) {
            list.add(new GeometryLocation(this.parentGeom, geometry, FacetLocater.toIntArray(stack)));
        }
    }
}

