/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jtstest.testbuilder.geom.GeometryVertexDeleter;
import com.vividsolutions.jtstest.testbuilder.geom.GeometryVertexInserter;

public class GeometryLocation {
    private Geometry parent;
    private Geometry component;
    private int[] componentPath;
    private int index;
    private boolean isVertex = true;
    private Coordinate pt;

    public GeometryLocation(Geometry geometry, Geometry geometry2, int[] nArray) {
        this.parent = geometry;
        this.component = geometry2;
        this.componentPath = nArray;
    }

    public GeometryLocation(Geometry geometry, Geometry geometry2, int n, Coordinate coordinate) {
        this.parent = geometry;
        this.component = geometry2;
        this.index = n;
        this.pt = coordinate;
    }

    public GeometryLocation(Geometry geometry, Geometry geometry2, int n, boolean bl, Coordinate coordinate) {
        this.parent = geometry;
        this.component = geometry2;
        this.index = n;
        this.isVertex = bl;
        this.pt = coordinate;
    }

    public GeometryLocation(Geometry geometry, Geometry geometry2, int[] nArray, int n, boolean bl, Coordinate coordinate) {
        this.parent = geometry;
        this.component = geometry2;
        this.componentPath = nArray;
        this.index = n;
        this.isVertex = bl;
        this.pt = coordinate;
    }

    public Geometry getComponent() {
        return this.component;
    }

    public Coordinate getCoordinate() {
        return this.pt;
    }

    public boolean isVertex() {
        return this.isVertex;
    }

    public Geometry insert() {
        return GeometryVertexInserter.insert(this.parent, (LineString)this.component, this.index, this.pt);
    }

    public Geometry delete() {
        return GeometryVertexDeleter.delete(this.parent, (LineString)this.component, this.index);
    }

    public String toString() {
        return this.pt.toString();
    }

    public String pathString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.componentPath.length; ++i) {
            if (i > 0) {
                stringBuffer.append(":");
            }
            stringBuffer.append(this.componentPath[i]);
        }
        return stringBuffer.toString();
    }

    public String toFacetString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < this.componentPath.length; ++i) {
            if (i > 0) {
                stringBuffer.append(":");
            }
            stringBuffer.append(this.componentPath[i]);
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.index);
        if (!this.isVertex()) {
            stringBuffer.append("-" + (this.index + 1));
        }
        stringBuffer.append("]  ");
        stringBuffer.append("( ");
        stringBuffer.append(this.pt.x);
        stringBuffer.append(" ");
        stringBuffer.append(this.pt.y);
        if (!this.isVertex()) {
            Coordinate coordinate = this.component.getCoordinates()[this.index + 1];
            stringBuffer.append(", ");
            stringBuffer.append(coordinate.x);
            stringBuffer.append(" ");
            stringBuffer.append(coordinate.y);
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }
}

