/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.io.shapefile;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.EndianDataInputStream;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.PointHandler;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.ShapeHandler;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.Shapefile;
import java.io.IOException;

public class ShapefileHeader {
    private static final boolean DEBUG = false;
    private int fileCode = -1;
    public int fileLength = -1;
    private int indexLength = -1;
    private int version = -1;
    private int shapeType = -1;
    private Envelope bounds;

    public ShapefileHeader(EndianDataInputStream endianDataInputStream) throws IOException {
        int n;
        this.fileCode = endianDataInputStream.readIntBE();
        if (this.fileCode != 9994) {
            System.err.println("Sfh->WARNING filecode " + this.fileCode + " not a match for documented shapefile code " + 9994);
        }
        for (n = 0; n < 5; ++n) {
            int n2 = endianDataInputStream.readIntBE();
        }
        this.fileLength = endianDataInputStream.readIntBE();
        this.version = endianDataInputStream.readIntLE();
        this.shapeType = endianDataInputStream.readIntLE();
        for (n = 0; n < 4; ++n) {
            endianDataInputStream.readDoubleLE();
        }
        endianDataInputStream.skipBytes(32);
    }

    public ShapefileHeader(GeometryCollection geometryCollection, int n) throws Exception {
        ShapeHandler shapeHandler = geometryCollection.getNumGeometries() == 0 ? new PointHandler() : Shapefile.getShapeHandler(geometryCollection.getGeometryN(0), n);
        int n2 = geometryCollection.getNumGeometries();
        this.shapeType = shapeHandler.getShapeType();
        this.version = 1000;
        this.fileCode = 9994;
        this.bounds = geometryCollection.getEnvelopeInternal();
        this.fileLength = 0;
        for (int i = 0; i < n2; ++i) {
            this.fileLength += shapeHandler.getLength(geometryCollection.getGeometryN(i));
            this.fileLength += 4;
        }
        this.fileLength += 50;
        this.indexLength = 50 + 4 * n2;
    }

    public void setFileLength(int n) {
        this.fileLength = n;
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public int getVersion() {
        return this.version;
    }

    public Envelope getBounds() {
        return this.bounds;
    }

    public String toString() {
        String string = new String("Sf-->type " + this.fileCode + " size " + this.fileLength + " version " + this.version + " Shape Type " + this.shapeType);
        return string;
    }
}

