/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.model;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilder;
import com.vividsolutions.jtstest.testbuilder.geom.AdjacentVertexFinder;
import com.vividsolutions.jtstest.testbuilder.geom.GeometryCombiner;
import com.vividsolutions.jtstest.testbuilder.geom.GeometryLocation;
import com.vividsolutions.jtstest.testbuilder.geom.GeometryPointLocater;
import com.vividsolutions.jtstest.testbuilder.geom.GeometryUtil;
import com.vividsolutions.jtstest.testbuilder.geom.GeometryVertexMover;
import com.vividsolutions.jtstest.testbuilder.model.GeometryEvent;
import com.vividsolutions.jtstest.testbuilder.model.GeometryListener;
import com.vividsolutions.jtstest.testbuilder.model.TestCaseEdit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public class GeometryEditModel {
    private static WKTWriter wktWriter = new WKTWriter();
    private boolean readOnly = true;
    private int geomIndex = 0;
    private int geomType = 5;
    private TestCaseEdit testCase;
    private transient Vector geometryListeners;

    public Envelope getEnvelope() {
        Envelope envelope = new Envelope();
        if (this.getGeometry(0) != null) {
            envelope.expandToInclude(this.getGeometry(0).getEnvelopeInternal());
        }
        if (this.getGeometry(1) != null) {
            envelope.expandToInclude(this.getGeometry(1).getEnvelopeInternal());
        }
        return envelope;
    }

    public Envelope getEnvelopeAll() {
        Envelope envelope = new Envelope();
        if (this.getGeometry(0) != null) {
            envelope.expandToInclude(this.getGeometry(0).getEnvelopeInternal());
        }
        if (this.getGeometry(1) != null) {
            envelope.expandToInclude(this.getGeometry(1).getEnvelopeInternal());
        }
        if (this.getResult() != null) {
            envelope.expandToInclude(this.getResult().getEnvelopeInternal());
        }
        return envelope;
    }

    public int getGeomIndex() {
        return this.geomIndex;
    }

    public void setGeomIndex(int n) {
        this.geomIndex = n;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void clear() {
        this.setGeometry(null);
        this.geomChanged();
    }

    public int getGeometryType() {
        return this.geomType;
    }

    public void setGeometryType(int n) {
        this.geomType = n;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public String getText(int n) {
        String string = "";
        if (this.getGeometry(0) != null) {
            string = string + GeometryEditModel.getText(this.getGeometry(0), n);
            string = string + "\n\n";
        }
        if (this.getGeometry(1) != null) {
            string = string + GeometryEditModel.getText(this.getGeometry(1), n);
            string = string + "\n\n";
        }
        return string;
    }

    public static String getText(Geometry geometry, int n) {
        switch (n) {
            case 1: {
                String string = wktWriter.writeFormatted(geometry);
                return string;
            }
        }
        Assert.shouldNeverReachHere();
        return "";
    }

    public static String toStringVeryLarge(Geometry geometry) {
        return "[[ " + GeometryUtil.structureSummary(geometry) + " ]]";
    }

    public Geometry getResult() {
        return this.testCase.getResult();
    }

    public Geometry getGeometry() {
        return this.getGeometry(this.geomIndex);
    }

    public Geometry getGeometry(int n) {
        return this.testCase.getGeometry(n);
    }

    public void setTestCase(TestCaseEdit testCaseEdit) {
        this.testCase = testCaseEdit;
        this.geomChanged();
    }

    public void setGeometry(Geometry geometry) {
        this.setGeometry(this.geomIndex, geometry);
        this.geomChanged();
    }

    public void setGeometry(int n, Geometry geometry) {
        this.testCase.setGeometry(n, geometry);
        this.geomChanged();
    }

    public void clear(int n) {
        this.setGeometry(n, null);
        this.geomChanged();
    }

    public void addComponent(List list) {
        GeometryCombiner geometryCombiner = new GeometryCombiner(JTSTestBuilder.getGeometryFactory());
        Geometry geometry = null;
        switch (this.getGeometryType()) {
            case 5: {
                geometry = geometryCombiner.addPolygonRing(this.getGeometry(), GeometryEditModel.getRing(list));
                break;
            }
            case 6: {
                Coordinate[] coordinateArray = CoordinateArrays.toCoordinateArray((Collection)list);
                geometry = geometryCombiner.addLineString(this.getGeometry(), coordinateArray);
                break;
            }
            case 7: {
                geometry = geometryCombiner.addPoint(this.getGeometry(), (Coordinate)list.get(0));
            }
        }
        this.setGeometry(geometry);
    }

    private static Coordinate[] getRing(List arrayList) {
        Coordinate coordinate;
        ArrayList<Object> arrayList2 = arrayList;
        Coordinate coordinate2 = (Coordinate)arrayList.get(0);
        if (!coordinate2.equals2D(coordinate = (Coordinate)arrayList.get(arrayList.size() - 1))) {
            arrayList2 = new ArrayList<Object>(arrayList);
            arrayList2.add(coordinate2.clone());
        }
        Coordinate[] coordinateArray = CoordinateArrays.toCoordinateArray((Collection)arrayList2);
        return coordinateArray;
    }

    public Coordinate[] findAdjacentVertices(Coordinate coordinate) {
        Geometry geometry = this.getGeometry();
        if (geometry == null) {
            return null;
        }
        return AdjacentVertexFinder.findVertices(this.getGeometry(), coordinate);
    }

    public GeometryLocation locateNonVertexPoint(Coordinate coordinate, double d) {
        Geometry geometry = this.getGeometry();
        if (geometry == null) {
            return null;
        }
        return GeometryPointLocater.locateNonVertexPoint(this.getGeometry(), coordinate, d);
    }

    public GeometryLocation locateVertex(Coordinate coordinate, double d) {
        Geometry geometry = this.getGeometry();
        if (geometry == null) {
            return null;
        }
        return GeometryPointLocater.locateVertex(this.getGeometry(), coordinate, d);
    }

    public Coordinate locateVertexPt(Coordinate coordinate, double d) {
        Geometry geometry = this.getGeometry();
        if (geometry == null) {
            return null;
        }
        GeometryLocation geometryLocation = this.locateVertex(coordinate, d);
        if (geometryLocation == null) {
            return null;
        }
        return geometryLocation.getCoordinate();
    }

    public void moveVertex(Coordinate coordinate, Coordinate coordinate2) {
        Geometry geometry = GeometryVertexMover.move(this.getGeometry(), coordinate, coordinate2);
        this.setGeometry(geometry);
    }

    public void geomChanged() {
        this.fireGeometryChanged(new GeometryEvent(this));
    }

    public synchronized void removeGeometryListener(GeometryListener geometryListener) {
        if (this.geometryListeners != null && this.geometryListeners.contains(geometryListener)) {
            Vector vector = (Vector)this.geometryListeners.clone();
            vector.removeElement(geometryListener);
            this.geometryListeners = vector;
        }
    }

    public synchronized void addGeometryListener(GeometryListener geometryListener) {
        Vector vector;
        Vector vector2 = vector = this.geometryListeners == null ? new Vector(2) : (Vector)this.geometryListeners.clone();
        if (!vector.contains(geometryListener)) {
            vector.addElement(geometryListener);
            this.geometryListeners = vector;
        }
    }

    public void fireGeometryChanged(GeometryEvent geometryEvent) {
        if (this.geometryListeners != null) {
            Vector vector = this.geometryListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((GeometryListener)vector.elementAt(i)).geometryChanged(geometryEvent);
            }
        }
    }
}

