/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.model;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.testbuilder.Viewport;
import com.vividsolutions.jtstest.testbuilder.geom.GeometryContainer;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import com.vividsolutions.jtstest.testbuilder.ui.render.ArrowEndpointStyle;
import com.vividsolutions.jtstest.testbuilder.ui.render.BasicStyle;
import com.vividsolutions.jtstest.testbuilder.ui.render.CircleEndpointStyle;
import com.vividsolutions.jtstest.testbuilder.ui.render.GeometryPainter;
import com.vividsolutions.jtstest.testbuilder.ui.render.LineOrientationStyle;
import com.vividsolutions.jtstest.testbuilder.ui.render.Style;
import com.vividsolutions.jtstest.testbuilder.ui.render.StyleList;
import com.vividsolutions.jtstest.testbuilder.ui.render.VertexStyle;
import java.awt.Color;
import java.awt.Graphics2D;

public class Layer {
    private String name = "";
    private GeometryContainer geomCont;
    private boolean isEnabled = true;
    private BasicStyle style = new BasicStyle();
    private VertexStyle vertexStyle;
    private LineOrientationStyle segArrowStyle;
    private ArrowEndpointStyle lineArrowStyle;
    private CircleEndpointStyle lineCircleStyle;
    private StyleList styleList;
    private StyleList.StyleFilter vertexFilter = new StyleList.StyleFilter(){

        public boolean isFiltered(Style style) {
            return !TestBuilderModel.isShowingVertices();
        }
    };
    private StyleList.StyleFilter decorationFilter = new StyleList.StyleFilter(){

        public boolean isFiltered(Style style) {
            return !TestBuilderModel.isShowingOrientations();
        }
    };

    private static Color lighter(Color color) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        fArray[1] = (float)((double)fArray[1] * 0.4);
        return Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
    }

    public Layer(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public void setGeometry(GeometryContainer geometryContainer) {
        this.geomCont = geometryContainer;
    }

    public void setStyle(BasicStyle basicStyle) {
        this.style = basicStyle;
        this.vertexStyle = new VertexStyle(basicStyle.getLineColor());
        this.segArrowStyle = new LineOrientationStyle(Layer.lighter(basicStyle.getLineColor()));
        this.lineArrowStyle = new ArrowEndpointStyle(Layer.lighter(basicStyle.getLineColor()), false, true);
        this.lineCircleStyle = new CircleEndpointStyle(Layer.lighter(basicStyle.getLineColor()), true, false);
        this.styleList = new StyleList();
        this.styleList.add(basicStyle);
        this.styleList.add(this.vertexStyle, this.vertexFilter);
        this.styleList.add(this.segArrowStyle, this.decorationFilter);
        this.styleList.add(this.lineArrowStyle, this.decorationFilter);
        this.styleList.add(this.lineCircleStyle, this.decorationFilter);
    }

    public Geometry getGeometry() {
        if (this.geomCont == null) {
            return null;
        }
        return this.geomCont.getGeometry();
    }

    public void paint(Graphics2D graphics2D, Viewport viewport) {
        if (!this.isEnabled) {
            return;
        }
        if (this.geomCont == null) {
            return;
        }
        try {
            Geometry geometry = this.geomCont.getGeometry();
            if (geometry == null) {
                return;
            }
            if (!viewport.intersectsInModel(geometry.getEnvelopeInternal())) {
                return;
            }
            GeometryPainter.paint(graphics2D, viewport, geometry, this.styleList);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

