/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.model;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jtstest.test.TestCaseList;
import com.vividsolutions.jtstest.test.Testable;
import com.vividsolutions.jtstest.testbuilder.model.GeometryDepiction;
import com.vividsolutions.jtstest.testbuilder.model.GeometryEditModel;
import com.vividsolutions.jtstest.testbuilder.model.IndexedGeometryContainer;
import com.vividsolutions.jtstest.testbuilder.model.Layer;
import com.vividsolutions.jtstest.testbuilder.model.LayerList;
import com.vividsolutions.jtstest.testbuilder.model.ResultGeometryContainer;
import com.vividsolutions.jtstest.testbuilder.model.TestCaseEdit;
import com.vividsolutions.jtstest.testbuilder.model.TestRunnerTestCaseAdapter;
import com.vividsolutions.jtstest.testbuilder.ui.SwingUtil;
import com.vividsolutions.jtstest.testbuilder.ui.render.BasicStyle;
import com.vividsolutions.jtstest.testrunner.TestCase;
import com.vividsolutions.jtstest.testrunner.TestReader;
import com.vividsolutions.jtstest.testrunner.TestRun;
import com.vividsolutions.jtstest.util.IOUtil;
import com.vividsolutions.jtstest.util.MultiFormatReader;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class TestBuilderModel {
    public static int MAX_DISPLAY_POINTS = 2000;
    protected static boolean showingGrid = true;
    protected static boolean showingOrientations = false;
    protected static boolean showingVertices = true;
    protected static boolean showingCoordinates = true;
    private PrecisionModel precisionModel = new PrecisionModel();
    private GeometryFactory geometryFactory = null;
    private GeometryEditModel geomEditModel;
    private LayerList layerList = new LayerList();
    private WKTWriter writer = new WKTWriter();
    private TestCaseList tcList = new TestCaseList();
    private ListIterator tcListi;
    private List parseErrors = null;
    private TestCaseEdit currTestCase;

    public static boolean isShowingOrientations() {
        return showingOrientations;
    }

    public static void setShowingOrientations(boolean bl) {
        showingOrientations = bl;
    }

    public static boolean isShowingGrid() {
        return showingGrid;
    }

    public static void setShowingGrid(boolean bl) {
        showingGrid = bl;
    }

    public static boolean isShowingVertices() {
        return showingVertices;
    }

    public static void setShowingVertices(boolean bl) {
        showingVertices = bl;
    }

    public TestBuilderModel() {
        this.geomEditModel = new GeometryEditModel();
        this.initLayers();
        this.initTestCaseList();
    }

    public GeometryEditModel getGeometryEditModel() {
        return this.geomEditModel;
    }

    public PrecisionModel getPrecisionModel() {
        return this.precisionModel;
    }

    public void setPrecisionModel(PrecisionModel precisionModel) {
        this.precisionModel = precisionModel;
        this.geometryFactory = null;
    }

    public GeometryFactory getGeometryFactory() {
        if (this.geometryFactory == null) {
            this.geometryFactory = new GeometryFactory(this.getPrecisionModel());
        }
        return this.geometryFactory;
    }

    public String getResultDisplayString(Geometry geometry) {
        if (geometry == null) {
            return "";
        }
        if (geometry.getNumPoints() > MAX_DISPLAY_POINTS) {
            return GeometryEditModel.toStringVeryLarge(geometry);
        }
        return this.writer.writeFormatted(geometry);
    }

    public LayerList getLayers() {
        return this.layerList;
    }

    private void initLayers() {
        this.layerList.getLayer(0).setGeometry(new IndexedGeometryContainer(this.geomEditModel, 0));
        this.layerList.getLayer(1).setGeometry(new IndexedGeometryContainer(this.geomEditModel, 1));
        if (this.geomEditModel != null) {
            this.layerList.getLayer(2).setGeometry(new ResultGeometryContainer(this.geomEditModel));
        }
        Layer layer = this.layerList.getLayer(0);
        layer.setStyle(new BasicStyle(GeometryDepiction.GEOM_A_LINE_CLR, GeometryDepiction.GEOM_A_FILL_CLR));
        Layer layer2 = this.layerList.getLayer(1);
        layer2.setStyle(new BasicStyle(GeometryDepiction.GEOM_B_LINE_CLR, GeometryDepiction.GEOM_B_FILL_CLR));
        Layer layer3 = this.layerList.getLayer(2);
        layer3.setStyle(new BasicStyle(GeometryDepiction.GEOM_RESULT_LINE_CLR, GeometryDepiction.GEOM_RESULT_FILL_CLR));
    }

    public void pasteGeometry(int n) throws ParseException, IOException {
        Object object = SwingUtil.getFromClipboard();
        Geometry geometry = null;
        geometry = object instanceof String ? this.readGeometryText((String)object) : (Geometry)object;
        TestCaseEdit testCaseEdit = this.getCurrentTestCaseEdit();
        testCaseEdit.setGeometry(n, geometry);
        this.getGeometryEditModel().setTestCase(testCaseEdit);
    }

    public Geometry readGeometryText(String string) throws ParseException, IOException {
        MultiFormatReader multiFormatReader = new MultiFormatReader(this.getGeometryFactory());
        Geometry geometry = null;
        if (string.length() > 0) {
            geometry = multiFormatReader.read(string);
        }
        return geometry;
    }

    public void loadMultipleGeometriesFromFile(int n, String string) throws Exception {
        Geometry geometry = IOUtil.readMultipleGeometriesFromFile(string, this.getGeometryFactory());
        TestCaseEdit testCaseEdit = this.getCurrentTestCaseEdit();
        testCaseEdit.setGeometry(n, geometry);
        this.getGeometryEditModel().setTestCase(testCaseEdit);
    }

    public void initTestCaseList() {
        this.tcList = new TestCaseList();
        this.tcListi = new IteratorWrapper(this.tcList.getList().listIterator());
        this.createNew();
    }

    public void initList(TestCaseList testCaseList) {
        this.tcList = testCaseList;
        this.tcListi = new IteratorWrapper(this.tcList.getList().listIterator());
        if (this.tcListi.hasNext()) {
            this.currTestCase = (TestCaseEdit)this.tcListi.next();
        } else {
            this.createNew();
        }
    }

    public void createNew() {
        while (this.tcListi.hasNext()) {
            this.tcListi.next();
        }
        this.currTestCase = new TestCaseEdit(this.precisionModel);
        this.tcListi.add(this.currTestCase);
    }

    public List getTestCases() {
        return Collections.unmodifiableList(this.tcList.getList());
    }

    public TestCaseList getTestCaseList() {
        return this.tcList;
    }

    public void setCurrentTestCase(TestCaseEdit testCaseEdit) {
        while (this.tcListi.hasPrevious()) {
            this.tcListi.previous();
        }
        while (this.tcListi.hasNext()) {
            if (this.tcListi.next() != testCaseEdit) continue;
            this.currTestCase = testCaseEdit;
            return;
        }
    }

    public TestCaseEdit getCurrentTestCaseEdit() {
        return this.currTestCase;
    }

    public Testable getCurrentTestable() {
        return this.currTestCase;
    }

    public int getCurrentTestIndex() {
        return this.tcListi.previousIndex();
    }

    public TestCaseList getTestList() {
        return this.tcList;
    }

    public int getTestListSize() {
        return this.tcList.getList().size();
    }

    public void openXmlFilesAndDirectories(File[] fileArray) throws Exception {
        Object object;
        TestCaseList testCaseList = this.createTestCaseList(fileArray);
        PrecisionModel precisionModel = new PrecisionModel();
        if (!testCaseList.getList().isEmpty()) {
            object = (TestRunnerTestCaseAdapter)testCaseList.getList().get(0);
            precisionModel = ((TestRunnerTestCaseAdapter)object).getTestRunnerTestCase().getTestRun().getPrecisionModel();
        }
        if (this.tcList.getList().size() == 1 && ((Testable)this.tcList.getList().get(0)).getGeometry(0) == null && ((Testable)this.tcList.getList().get(0)).getGeometry(1) == null) {
            this.loadTestCaseList(testCaseList, precisionModel);
        } else {
            object = new TestCaseList();
            ((TestCaseList)object).add(this.tcList);
            ((TestCaseList)object).add(testCaseList);
            this.loadTestCaseList((TestCaseList)object, precisionModel);
        }
    }

    void loadTestCaseList(TestCaseList testCaseList, PrecisionModel precisionModel) throws Exception {
        this.setPrecisionModel(precisionModel);
        if (testCaseList != null) {
            this.loadEditList(testCaseList);
        }
    }

    public void loadEditList(TestCaseList testCaseList) throws ParseException {
        TestCaseList testCaseList2 = new TestCaseList();
        Iterator iterator = testCaseList.getList().iterator();
        while (iterator.hasNext()) {
            Testable testable = (Testable)iterator.next();
            if (testable instanceof TestCaseEdit) {
                testCaseList2.add((TestCaseEdit)testable);
                continue;
            }
            testCaseList2.add(new TestCaseEdit(testable));
        }
        this.initList(testCaseList2);
    }

    private TestCaseList createTestCaseList(File[] fileArray) {
        TestCaseList testCaseList = new TestCaseList();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (file.isFile()) {
                testCaseList.add(this.createTestCaseList(file));
                continue;
            }
            if (!file.isDirectory()) continue;
            testCaseList.add(this.createTestCaseListFromDirectory(file));
        }
        return testCaseList;
    }

    private TestCaseList createTestCaseListFromDirectory(File file) {
        Assert.isTrue((boolean)file.isDirectory());
        TestCaseList testCaseList = new TestCaseList();
        List<File> list = Arrays.asList(file.listFiles());
        Iterator<File> iterator = list.iterator();
        while (iterator.hasNext()) {
            File file2 = iterator.next();
            testCaseList.add(this.createTestCaseList(file2));
        }
        return testCaseList;
    }

    private TestCaseList createTestCaseList(File file) {
        TestReader testReader = new TestReader();
        TestRun testRun = testReader.createTestRun(file, 1);
        this.parseErrors = testReader.getParsingProblems();
        TestCaseList testCaseList = new TestCaseList();
        if (this.hasParseErrors()) {
            return testCaseList;
        }
        Iterator iterator = testRun.getTestCases().iterator();
        while (iterator.hasNext()) {
            TestCase testCase = (TestCase)iterator.next();
            testCaseList.add(new TestRunnerTestCaseAdapter(testCase));
        }
        return testCaseList;
    }

    public List getParsingProblems() {
        return this.parseErrors;
    }

    public boolean hasParseErrors() {
        if (this.parseErrors == null) {
            return false;
        }
        return this.parseErrors.size() > 0;
    }

    public void prevCase() {
        if (this.tcListi.hasPrevious()) {
            this.tcListi.previous();
        }
        if (this.tcListi.hasPrevious()) {
            this.tcListi.previous();
        }
        this.currTestCase = (TestCaseEdit)this.tcListi.next();
    }

    public void nextCase() {
        if (this.tcListi.nextIndex() >= this.tcList.getList().size()) {
            return;
        }
        if (this.tcListi.hasNext()) {
            this.currTestCase = (TestCaseEdit)this.tcListi.next();
        }
    }

    public void copyCase() {
        TestCaseEdit testCaseEdit = null;
        testCaseEdit = new TestCaseEdit(this.currTestCase);
        this.tcListi.add(testCaseEdit);
        this.currTestCase = testCaseEdit;
    }

    public void addCase(Geometry[] geometryArray) {
        TestCaseEdit testCaseEdit = null;
        testCaseEdit = new TestCaseEdit(geometryArray);
        this.tcListi.add(testCaseEdit);
        this.currTestCase = testCaseEdit;
    }

    public void deleteCase() {
        this.tcListi.remove();
        if (this.tcListi.hasNext()) {
            this.currTestCase = (TestCaseEdit)this.tcListi.next();
        } else if (this.tcListi.hasPrevious()) {
            this.currTestCase = (TestCaseEdit)this.tcListi.previous();
        } else {
            this.createNew();
        }
    }

    private class IteratorWrapper
    implements ListIterator {
        ListIterator i;

        public IteratorWrapper(ListIterator listIterator) {
            this.i = listIterator;
        }

        public void set(Object object) {
            this.checkStop();
            this.i.set(object);
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            this.checkStop();
            return this.i.next();
        }

        public void remove() {
            this.checkStop();
            this.i.remove();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public Object previous() {
            this.checkStop();
            return this.i.previous();
        }

        public int nextIndex() {
            return this.i.nextIndex();
        }

        public int previousIndex() {
            return this.i.previousIndex();
        }

        public void add(Object object) {
            this.checkStop();
            this.i.add(object);
        }

        private void checkStop() {
            int n = 5;
        }
    }
}

