/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.render;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jtstest.testbuilder.Viewport;
import com.vividsolutions.jtstest.testbuilder.model.DrawingGrid;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class GridRenderer {
    private static final int MIN_VIEW_GRID_SIZE = 5;
    private static final Color axisColor = Color.gray;
    private static final Color gridColor = Color.lightGray;
    private static final Color gridMajorColor = new Color(240, 240, 240);
    private Viewport viewport;
    private DrawingGrid grid;
    private boolean isEnabled = true;
    private static final Coordinate modelOrigin = new Coordinate(0.0, 0.0);

    public GridRenderer(Viewport viewport, DrawingGrid drawingGrid) {
        this.viewport = viewport;
        this.grid = drawingGrid;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public void paint(Graphics2D graphics2D) {
        if (!this.isEnabled) {
            return;
        }
        if (this.isResolvable()) {
            this.drawLines(graphics2D);
        }
        this.drawAxes(graphics2D);
    }

    private boolean isResolvable() {
        Point2D point2D = this.viewport.toModel(new Point(0, 0));
        Point2D point2D2 = this.viewport.toModel(new Point(5, 0));
        return this.grid.isResolvable(point2D, point2D2);
    }

    public void drawGridPoints(Graphics2D graphics2D) {
        double d = this.grid.getGridSize();
        Point2D point2D = this.viewport.getLowerLeftCornerInModel();
        Point2D point2D2 = this.viewport.getUpperRightCornerInModel();
        double d2 = this.grid.snapToGrid(point2D).getX();
        double d3 = this.grid.snapToGrid(point2D2).getX();
        double d4 = this.grid.snapToGrid(point2D).getY();
        double d5 = this.grid.snapToGrid(point2D2).getY();
        graphics2D.setColor(gridColor);
        for (double d6 = d2; d6 < d3; d6 += d) {
            for (double d7 = d4; d7 < d5; d7 += d) {
                graphics2D.draw(new Line2D.Double(d6, d7, d6, d7));
            }
        }
    }

    public void drawAxes(Graphics2D graphics2D) {
        graphics2D.setColor(axisColor);
        Point2D point2D = this.viewport.convert(modelOrigin);
        double d = point2D.getX();
        double d2 = point2D.getY();
        if (d >= 0.0 && d <= this.viewport.getWidthInView()) {
            graphics2D.draw(new Line2D.Double(d, 0.0, d, this.viewport.getHeightInView()));
        }
        if (d2 >= 0.0 && d2 <= this.viewport.getHeightInView()) {
            graphics2D.draw(new Line2D.Double(0.0, d2, this.viewport.getWidthInView(), d2));
        }
    }

    public void drawLines(Graphics2D graphics2D) {
        double d;
        graphics2D.setColor(gridMajorColor);
        double d2 = this.grid.getGridSize();
        double d3 = d2 * this.viewport.getScale();
        Point2D point2D = this.viewport.getLowerLeftCornerInModel();
        double d4 = this.grid.snapToMajorGrid(point2D).getX();
        double d5 = this.grid.snapToMajorGrid(point2D).getY();
        double d6 = this.viewport.getWidthInView();
        double d7 = this.viewport.getHeightInView();
        Point2D point2D2 = this.viewport.convert(new Coordinate(d4, d5));
        for (d = point2D2.getX(); d < d6; d += d3) {
            if (d < 2.0) continue;
            graphics2D.draw(new Line2D.Double(d, 0.0, d, d7 - 0.0));
        }
        for (d = point2D2.getY(); d > 0.0; d -= d3) {
            if (d < 2.0) continue;
            graphics2D.draw(new Line2D.Double(0.0, d, d6 - 0.0, d));
        }
    }
}

