/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.tools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jtstest.testbuilder.AppColors;
import com.vividsolutions.jtstest.testbuilder.GeometryEditPanel;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilder;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.Viewport;
import com.vividsolutions.jtstest.testbuilder.model.GeometryEditModel;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import com.vividsolutions.jtstest.testbuilder.ui.tools.Tool;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;

public abstract class BasicTool
implements Tool,
MouseListener,
MouseMotionListener {
    public static int TOLERANCE_PIXELS = 5;
    private Color bandColor = AppColors.BAND_COLOR;
    private Stroke stroke = new BasicStroke(2.0f, 0, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);
    private Shape lastShapeDrawn;
    private boolean shapeOnScreen = false;
    private Color originalColor;
    private Stroke originalStroke;

    public boolean isIndicatorVisible() {
        return this.shapeOnScreen;
    }

    private void setShapeOnScreen(boolean bl) {
        this.shapeOnScreen = bl;
    }

    protected void clearIndicator() {
        this.clearShape(this.getGraphics2D());
    }

    private void clearShape(Graphics2D graphics2D) {
        if (!this.shapeOnScreen) {
            return;
        }
        this.drawShapeXOR(this.lastShapeDrawn, graphics2D);
        this.setShapeOnScreen(false);
    }

    private void redrawShape(Graphics2D graphics2D) throws Exception {
        this.clearShape(graphics2D);
        this.drawShapeXOR(graphics2D);
        this.setShapeOnScreen(true);
    }

    protected void drawShapeXOR(Graphics2D graphics2D) throws Exception {
        Shape shape = this.getShape();
        this.drawShapeXOR(shape, graphics2D);
        this.lastShapeDrawn = shape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawShapeXOR(Shape shape, Graphics2D graphics2D) {
        this.setup(graphics2D);
        try {
            if (shape != null) {
                graphics2D.draw(shape);
            }
        }
        finally {
            this.cleanup(graphics2D);
        }
    }

    protected void redrawIndicator() {
        try {
            this.redrawShape(this.getGraphics2D());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Shape getShape() {
        return null;
    }

    protected void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    protected void setup(Graphics2D graphics2D) {
        this.originalColor = graphics2D.getColor();
        this.originalStroke = graphics2D.getStroke();
        graphics2D.setColor(this.bandColor);
        graphics2D.setXORMode(Color.white);
    }

    private Graphics2D getGraphics2D() {
        Graphics2D graphics2D = (Graphics2D)this.panel().getGraphics();
        if (graphics2D != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        return graphics2D;
    }

    protected void cleanup(Graphics2D graphics2D) {
        graphics2D.setPaintMode();
        graphics2D.setColor(this.originalColor);
        graphics2D.setStroke(this.originalStroke);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(0);
    }

    public void activate() {
    }

    protected GeometryEditPanel panel() {
        return JTSTestBuilderFrame.getInstance().getTestCasePanel().getGeometryEditPanel();
    }

    protected GeometryEditModel geomModel() {
        return JTSTestBuilder.getInstance().getModel().getGeometryEditModel();
    }

    protected TestBuilderModel testBuilderModel() {
        return JTSTestBuilder.getInstance().getModel();
    }

    protected Viewport getViewport() {
        return this.panel().getViewport();
    }

    Point2D toViewPoint(Coordinate coordinate) {
        return this.getViewport().convert(coordinate);
    }

    Point2D toModelPoint(Point point) {
        return this.getViewport().toModel(point);
    }

    Coordinate toModelCoordinate(Point point) {
        return this.getViewport().toModelCoordinate(point);
    }

    double toModelDistance(double d) {
        return d / this.getViewport().getScale();
    }

    double getModelTolerance() {
        return this.toModelDistance(TOLERANCE_PIXELS);
    }

    protected Coordinate snapInModel(Point2D point2D) {
        Point2D point2D2 = this.panel().snapToGrid(this.getViewport().toModel(point2D));
        return new Coordinate(point2D2.getX(), point2D2.getY());
    }
}

