/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testrunner;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jtstest.testrunner.Test;
import com.vividsolutions.jtstest.testrunner.TestRun;
import com.vividsolutions.jtstest.util.StringUtil;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TestCase
implements Runnable {
    private String description;
    private Geometry a;
    private Geometry b;
    private Vector tests = new Vector();
    private TestRun testRun;
    private int caseIndex;
    private int lineNumber;
    private File aWktFile;
    private File bWktFile;
    private boolean isRun = false;

    public TestCase(String string, Geometry geometry, Geometry geometry2, File file, File file2, TestRun testRun, int n, int n2) {
        this.description = string;
        this.a = geometry;
        this.b = geometry2;
        this.aWktFile = file;
        this.bWktFile = file2;
        this.testRun = testRun;
        this.caseIndex = n;
        this.lineNumber = n2;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setGeometryA(Geometry geometry) {
        this.aWktFile = null;
        this.a = geometry;
    }

    public void setGeometryB(Geometry geometry) {
        this.bWktFile = null;
        this.b = geometry;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public boolean isRun() {
        return this.isRun;
    }

    public Geometry getGeometryA() {
        return this.a;
    }

    public Geometry getGeometryB() {
        return this.b;
    }

    public int getTestCount() {
        return this.tests.size();
    }

    public List getTests() {
        return Collections.unmodifiableList(this.tests);
    }

    public TestRun getTestRun() {
        return this.testRun;
    }

    public int getCaseIndex() {
        return this.caseIndex;
    }

    public String getDescription() {
        return this.description;
    }

    public void add(Test test) {
        this.tests.add(test);
    }

    public void remove(Test test) {
        this.tests.remove(test);
    }

    public void run() {
        this.isRun = true;
        Iterator iterator = this.tests.iterator();
        while (iterator.hasNext()) {
            Test test = (Test)iterator.next();
            test.run();
        }
    }

    public String toXml() {
        WKTWriter wKTWriter = new WKTWriter();
        String string = "";
        string = string + "<case>" + StringUtil.newLine;
        if (this.description != null && this.description.length() > 0) {
            string = string + "  <desc>" + StringUtil.escapeHTML(this.description) + "</desc>" + StringUtil.newLine;
        }
        string = string + this.xml("a", this.a, this.aWktFile, wKTWriter) + StringUtil.newLine;
        string = string + this.xml("b", this.b, this.bWktFile, wKTWriter);
        Iterator iterator = this.tests.iterator();
        while (iterator.hasNext()) {
            Test test = (Test)iterator.next();
            string = string + test.toXml();
        }
        string = string + "</case>" + StringUtil.newLine;
        return string;
    }

    private String xml(String string, Geometry geometry, File file, WKTWriter wKTWriter) {
        if (geometry == null) {
            return "";
        }
        if (file != null) {
            return "  <" + string + " file=\"" + file + "\"/>";
        }
        String string2 = "";
        string2 = string2 + "  <" + string + ">" + StringUtil.newLine;
        string2 = string2 + StringUtil.indent(wKTWriter.writeFormatted(geometry), 4) + StringUtil.newLine;
        string2 = string2 + "  </" + string + ">" + StringUtil.newLine;
        return string2;
    }
}

