/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtsexample.geom;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;

public class PrecisionModelExample {
    public static void main(String[] stringArray) {
        PrecisionModelExample precisionModelExample = new PrecisionModelExample();
        try {
            precisionModelExample.run();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void run() throws ParseException {
        this.example1();
        this.example2();
    }

    public void example1() throws ParseException {
        System.out.println("-------------------------------------------");
        System.out.println("Example 1 shows roundoff from computing in different precision models");
        String string = "POLYGON ((60 180, 160 260, 240 80, 60 180))";
        String string2 = "POLYGON ((200 260, 280 160, 80 100, 200 260))";
        System.out.println("A = " + string);
        System.out.println("B = " + string2);
        this.intersection(string, string2, new PrecisionModel());
        this.intersection(string, string2, new PrecisionModel(PrecisionModel.FLOATING_SINGLE));
        this.intersection(string, string2, new PrecisionModel(1.0));
    }

    public void example2() throws ParseException {
        System.out.println("-------------------------------------------");
        System.out.println("Example 2 shows that roundoff can change the topology of geometry computed in different precision models");
        String string = "POLYGON ((0 0, 160 0, 160 1, 0 0))";
        String string2 = "POLYGON ((40 60, 40 -20, 140 -20, 140 60, 40 60))";
        System.out.println("A = " + string);
        System.out.println("B = " + string2);
        this.difference(string, string2, new PrecisionModel());
        this.difference(string, string2, new PrecisionModel(1.0));
    }

    public void intersection(String string, String string2, PrecisionModel precisionModel) throws ParseException {
        System.out.println("Running example using Precision Model = " + precisionModel);
        GeometryFactory geometryFactory = new GeometryFactory(precisionModel);
        WKTReader wKTReader = new WKTReader(geometryFactory);
        Geometry geometry = wKTReader.read(string);
        Geometry geometry2 = wKTReader.read(string2);
        Geometry geometry3 = geometry.intersection(geometry2);
        System.out.println("A intersection B = " + geometry3);
    }

    public void difference(String string, String string2, PrecisionModel precisionModel) throws ParseException {
        System.out.println("-------------------------------------------");
        System.out.println("Running example using Precision Model = " + precisionModel);
        GeometryFactory geometryFactory = new GeometryFactory(precisionModel);
        WKTReader wKTReader = new WKTReader(geometryFactory);
        Geometry geometry = wKTReader.read(string);
        Geometry geometry2 = wKTReader.read(string2);
        Geometry geometry3 = geometry.difference(geometry2);
        System.out.println("A intersection B = " + geometry3);
    }
}

