/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.function;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryCollectionIterator;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jtstest.function.FunctionsUtil;
import com.vividsolutions.jtstest.function.LineHandlingFunctions;
import java.util.ArrayList;

public class BufferByUnionFunctions {
    public static Geometry componentBuffers(Geometry geometry, double d) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        GeometryCollectionIterator geometryCollectionIterator = new GeometryCollectionIterator(geometry);
        while (geometryCollectionIterator.hasNext()) {
            Geometry geometry2 = (Geometry)geometryCollectionIterator.next();
            if (geometry2 instanceof GeometryCollection) continue;
            arrayList.add(geometry2.buffer(d));
        }
        return FunctionsUtil.getFactoryOrDefault(geometry).createGeometryCollection(GeometryFactory.toGeometryArray(arrayList));
    }

    public static Geometry bufferByComponents(Geometry geometry, double d) {
        return BufferByUnionFunctions.componentBuffers(geometry, d).union();
    }

    public static Geometry bufferBySegments(Geometry geometry, double d) {
        Geometry geometry2 = LineHandlingFunctions.extractSegments(geometry);
        double d2 = Math.abs(d);
        Geometry geometry3 = BufferByUnionFunctions.bufferByComponents(geometry2, d2);
        if (d < 0.0) {
            return geometry.difference(geometry3);
        }
        return geometry.union(geometry3);
    }

    public static Geometry bufferByChains(Geometry geometry, double d, int n) {
        Geometry geometry2 = LineHandlingFunctions.extractChains(geometry, n);
        double d2 = Math.abs(d);
        Geometry geometry3 = BufferByUnionFunctions.bufferByComponents(geometry2, d2);
        if (d < 0.0) {
            return geometry.difference(geometry3);
        }
        return geometry.union(geometry3);
    }
}

