/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.function;

import com.vividsolutions.jts.awt.FontGlyphReader;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import com.vividsolutions.jts.geom.util.AffineTransformationFactory;
import com.vividsolutions.jts.util.GeometricShapeFactory;
import com.vividsolutions.jtstest.function.FunctionsUtil;
import java.awt.Font;
import java.util.ArrayList;

public class CreateShapeFunctions {
    private static final int DEFAULT_POINTSIZE = 100;

    public static Geometry fontGlyphSerif(Geometry geometry, String string) {
        return CreateShapeFunctions.fontGlyph(geometry, string, new Font("Serif", 0, 100));
    }

    public static Geometry fontGlyphSanSerif(Geometry geometry, String string) {
        return CreateShapeFunctions.fontGlyph(geometry, string, new Font("SanSerif", 0, 100));
    }

    public static Geometry fontGlyphMonospaced(Geometry geometry, String string) {
        return CreateShapeFunctions.fontGlyph(geometry, string, new Font("Monospaced", 0, 100));
    }

    private static Geometry fontGlyph(Geometry geometry, String string, Font font) {
        Envelope envelope = FunctionsUtil.getEnvelopeOrDefault(geometry);
        GeometryFactory geometryFactory = FunctionsUtil.getFactoryOrDefault(geometry);
        Geometry geometry2 = FontGlyphReader.read((String)string, (Font)font, (GeometryFactory)geometryFactory);
        Envelope envelope2 = geometry2.getEnvelopeInternal();
        if (geometry != null) {
            Coordinate coordinate = new Coordinate(envelope2.getMinX(), envelope2.getMinY());
            Coordinate coordinate2 = new Coordinate(envelope2.getMaxX(), envelope2.getMinY());
            Coordinate coordinate3 = new Coordinate(envelope.getMinX(), envelope.getMinY());
            Coordinate coordinate4 = new Coordinate(envelope.getMaxX(), envelope.getMinY());
            AffineTransformation affineTransformation = AffineTransformationFactory.createFromBaseLines((Coordinate)coordinate, (Coordinate)coordinate2, (Coordinate)coordinate3, (Coordinate)coordinate4);
            return affineTransformation.transform(geometry2);
        }
        return geometry2;
    }

    public static Geometry grid(Geometry geometry, int n) {
        Envelope envelope = FunctionsUtil.getEnvelopeOrDefault(geometry);
        GeometryFactory geometryFactory = FunctionsUtil.getFactoryOrDefault(geometry);
        int n2 = (int)Math.sqrt(n);
        int n3 = n / n2;
        double d = envelope.getWidth() / (double)n3;
        double d2 = envelope.getHeight() / (double)n2;
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d3 = envelope.getMinX() + (double)i * d;
                double d4 = envelope.getMinY() + (double)j * d2;
                Envelope envelope2 = new Envelope(d3, d3 + d, d4, d4 + d2);
                arrayList.add(geometryFactory.toGeometry(envelope2));
            }
        }
        return geometryFactory.buildGeometry(arrayList);
    }

    public static Geometry supercircle3(Geometry geometry, int n) {
        return CreateShapeFunctions.supercircle(geometry, n, 3.0);
    }

    public static Geometry squircle(Geometry geometry, int n) {
        return CreateShapeFunctions.supercircle(geometry, n, 4.0);
    }

    public static Geometry supercircle5(Geometry geometry, int n) {
        return CreateShapeFunctions.supercircle(geometry, n, 5.0);
    }

    public static Geometry supercirclePoint5(Geometry geometry, int n) {
        return CreateShapeFunctions.supercircle(geometry, n, 0.5);
    }

    public static Geometry supercircle(Geometry geometry, int n, double d) {
        GeometricShapeFactory geometricShapeFactory = new GeometricShapeFactory();
        geometricShapeFactory.setNumPoints(n);
        if (geometry != null) {
            geometricShapeFactory.setEnvelope(geometry.getEnvelopeInternal());
        } else {
            geometricShapeFactory.setEnvelope(new Envelope(0.0, 1.0, 0.0, 1.0));
        }
        return geometricShapeFactory.createSupercircle(d);
    }

    public static Geometry ellipse(Geometry geometry, int n) {
        GeometricShapeFactory geometricShapeFactory = new GeometricShapeFactory();
        geometricShapeFactory.setNumPoints(n);
        if (geometry != null) {
            geometricShapeFactory.setEnvelope(geometry.getEnvelopeInternal());
        } else {
            geometricShapeFactory.setEnvelope(new Envelope(0.0, 1.0, 0.0, 1.0));
        }
        return geometricShapeFactory.createCircle();
    }

    public static Geometry ellipseRotate(Geometry geometry, int n, double d) {
        GeometricShapeFactory geometricShapeFactory = new GeometricShapeFactory();
        geometricShapeFactory.setNumPoints(n);
        geometricShapeFactory.setRotation(d);
        if (geometry != null) {
            geometricShapeFactory.setEnvelope(geometry.getEnvelopeInternal());
        } else {
            geometricShapeFactory.setEnvelope(new Envelope(0.0, 1.0, 0.0, 1.0));
        }
        return geometricShapeFactory.createCircle();
    }
}

