/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.function;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.operation.linemerge.LineMerger;
import com.vividsolutions.jts.operation.linemerge.LineSequencer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LineHandlingFunctions {
    public static Geometry mergeLines(Geometry geometry) {
        LineMerger lineMerger = new LineMerger();
        lineMerger.add(geometry);
        Collection collection = lineMerger.getMergedLineStrings();
        return geometry.getFactory().buildGeometry(collection);
    }

    public static Geometry sequenceLines(Geometry geometry) {
        return LineSequencer.sequence((Geometry)geometry);
    }

    public static Geometry extractLines(Geometry geometry) {
        List list = LinearComponentExtracter.getLines((Geometry)geometry);
        return geometry.getFactory().buildGeometry((Collection)list);
    }

    public static Geometry extractSegments(Geometry geometry) {
        List list = LinearComponentExtracter.getLines((Geometry)geometry);
        ArrayList<LineString> arrayList = new ArrayList<LineString>();
        for (LineString lineString : list) {
            for (int i = 1; i < lineString.getNumPoints(); ++i) {
                LineString lineString2 = geometry.getFactory().createLineString(new Coordinate[]{lineString.getCoordinateN(i - 1), lineString.getCoordinateN(i)});
                arrayList.add(lineString2);
            }
        }
        return geometry.getFactory().buildGeometry(arrayList);
    }

    public static Geometry extractChains(Geometry geometry, int n) {
        List list = LinearComponentExtracter.getLines((Geometry)geometry);
        ArrayList<LineString> arrayList = new ArrayList<LineString>();
        for (LineString lineString : list) {
            for (int i = 0; i < lineString.getNumPoints() - 1; i += n) {
                LineString lineString2 = LineHandlingFunctions.extractChain(lineString, i, n);
                arrayList.add(lineString2);
            }
        }
        return geometry.getFactory().buildGeometry(arrayList);
    }

    private static LineString extractChain(LineString lineString, int n, int n2) {
        int n3 = n2 + 1;
        if (n + n3 > lineString.getNumPoints()) {
            n3 = lineString.getNumPoints() - n;
        }
        Coordinate[] coordinateArray = new Coordinate[n3];
        for (int i = 0; i < n3; ++i) {
            coordinateArray[i] = lineString.getCoordinateN(n + i);
        }
        return lineString.getFactory().createLineString(coordinateArray);
    }
}

