/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.function;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.function.GeometryPredicate;
import java.util.ArrayList;

public class SelectionFunctions {
    public static Geometry intersects(Geometry geometry, final Geometry geometry2) {
        return SelectionFunctions.select(geometry, new GeometryPredicate(){

            public boolean isTrue(Geometry geometry) {
                return geometry2.intersects(geometry);
            }
        });
    }

    public static Geometry covers(Geometry geometry, final Geometry geometry2) {
        return SelectionFunctions.select(geometry, new GeometryPredicate(){

            public boolean isTrue(Geometry geometry) {
                return geometry.covers(geometry2);
            }
        });
    }

    public static Geometry coveredBy(Geometry geometry, final Geometry geometry2) {
        return SelectionFunctions.select(geometry, new GeometryPredicate(){

            public boolean isTrue(Geometry geometry) {
                return geometry.coveredBy(geometry2);
            }
        });
    }

    public static Geometry disjoint(Geometry geometry, Geometry geometry2) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry geometry3 = geometry.getGeometryN(i);
            if (!geometry2.disjoint(geometry3)) continue;
            arrayList.add(geometry3);
        }
        return geometry.getFactory().buildGeometry(arrayList);
    }

    public static Geometry valid(Geometry geometry) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry geometry2 = geometry.getGeometryN(i);
            if (!geometry2.isValid()) continue;
            arrayList.add(geometry2);
        }
        return geometry.getFactory().buildGeometry(arrayList);
    }

    public static Geometry invalid(Geometry geometry) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry geometry2 = geometry.getGeometryN(i);
            if (geometry2.isValid()) continue;
            arrayList.add(geometry2);
        }
        return geometry.getFactory().buildGeometry(arrayList);
    }

    public static Geometry areaGreater(Geometry geometry, final double d) {
        return SelectionFunctions.select(geometry, new GeometryPredicate(){

            public boolean isTrue(Geometry geometry) {
                return geometry.getArea() > d;
            }
        });
    }

    public static Geometry areaZero(Geometry geometry) {
        return SelectionFunctions.select(geometry, new GeometryPredicate(){

            public boolean isTrue(Geometry geometry) {
                return geometry.getArea() == 0.0;
            }
        });
    }

    public static Geometry within(Geometry geometry, final Geometry geometry2) {
        return SelectionFunctions.select(geometry, new GeometryPredicate(){

            public boolean isTrue(Geometry geometry) {
                return geometry.within(geometry2);
            }
        });
    }

    private static Geometry select(Geometry geometry, GeometryPredicate geometryPredicate) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry geometry2 = geometry.getGeometryN(i);
            if (!geometryPredicate.isTrue(geometry2)) continue;
            arrayList.add(geometry2);
        }
        return geometry.getFactory().buildGeometry(arrayList);
    }
}

