/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.geomop;

public class ArgumentConverter {
    public Object[] convert(Class[] classArray, Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = this.convert(classArray[i], objectArray[i]);
        }
        return objectArray2;
    }

    public Object convert(Class clazz, Object object) {
        if (object instanceof String) {
            return this.convertFromString(clazz, (String)object);
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            return object;
        }
        this.throwInvalidConversion(clazz, object);
        return null;
    }

    private Object convertFromString(Class clazz, String string) {
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            if (string.equals("true")) {
                return new Boolean(true);
            }
            if (string.equals("false")) {
                return new Boolean(false);
            }
            this.throwInvalidConversion(clazz, string);
        } else if (clazz == Integer.class || clazz == Integer.TYPE) {
            try {
                return new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (clazz == Double.class || clazz == Double.TYPE) {
            try {
                return new Double(string);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (clazz == String.class) {
            return string;
        }
        this.throwInvalidConversion(clazz, string);
        return null;
    }

    private void throwInvalidConversion(Class clazz, Object object) {
        throw new IllegalArgumentException("Cannot convert " + object + " to " + clazz.getName());
    }
}

