/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.testbuilder.GeometryNode;
import com.vividsolutions.jtstest.testbuilder.GeometryTreeModel;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class GeometryTreePanel
extends JPanel
implements TreeWillExpandListener {
    JScrollPane jScrollPane = new JScrollPane();
    JTree tree = new JTree();
    BorderLayout borderLayout = new BorderLayout();
    Border border1;

    public GeometryTreePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(200, 250);
        this.border1 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        this.setLayout(this.borderLayout);
        this.setBorder(this.border1);
        this.add((Component)this.jScrollPane, "Center");
        this.jScrollPane.getViewport().add((Component)this.tree, null);
        this.tree.setRootVisible(true);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new GeometryTreeCellRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setToggleClickCount(0);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1) {
                    JTSTestBuilderFrame.getGeometryEditPanel().flash(GeometryTreePanel.this.getSelectedGeometry());
                } else if (mouseEvent.getClickCount() == 2) {
                    JTSTestBuilderFrame.getGeometryEditPanel().zoom(GeometryTreePanel.this.getSelectedGeometry().getEnvelopeInternal());
                }
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            }
        });
    }

    public Geometry getSelectedGeometry() {
        return GeometryTreePanel.getGeometryFromNode(this.tree.getLastSelectedPathComponent());
    }

    private static Geometry getGeometryFromNode(Object object) {
        return ((GeometryNode)object).getGeometry();
    }

    public void populate(Geometry geometry) {
        this.tree.setModel(new GeometryTreeModel(geometry));
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        TreePath treePath = treeExpansionEvent.getPath();
        Object object = treePath.getLastPathComponent();
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
    }

    private class GeometryTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (!(object instanceof GeometryNode)) {
                return this;
            }
            GeometryNode geometryNode = (GeometryNode)object;
            this.setText(geometryNode.getText());
            return this;
        }
    }
}

