/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.util.Stopwatch;
import com.vividsolutions.jtstest.function.GeometryFunction;
import com.vividsolutions.jtstest.testbuilder.GeometryEditPanel;
import com.vividsolutions.jtstest.testbuilder.GeometryFunctionEvent;
import com.vividsolutions.jtstest.testbuilder.GeometryFunctionListener;
import com.vividsolutions.jtstest.testbuilder.GeometryFunctionTreePanel;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilder;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.SpatialFunctionPanelEvent;
import com.vividsolutions.jtstest.testbuilder.SpatialFunctionPanelListener;
import com.vividsolutions.jtstest.testbuilder.model.FunctionParameters;
import com.vividsolutions.jtstest.testbuilder.ui.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SpatialFunctionPanel
extends JPanel {
    private static String[] capStyleItems = new String[]{"", "Round", "Flat", "Square"};
    private static Object[] capStyleValues = new Object[]{null, new Integer(1), new Integer(2), new Integer(3)};
    private static String[] joinStyleItems = new String[]{"", "Round", "Mitre", "Bevel"};
    private static Object[] joinStyleValues = new Object[]{null, new Integer(1), new Integer(2), new Integer(3)};
    JPanel panelRB = new JPanel();
    GeometryFunctionTreePanel geomFuncPanel = new GeometryFunctionTreePanel();
    GridLayout gridLayout1 = new GridLayout();
    GridLayout gridLayout2 = new GridLayout();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel panelParam = new JPanel();
    JPanel panelExec = new JPanel();
    JPanel panelExecParam = new JPanel();
    FlowLayout flowLayout = new FlowLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    JButton execButton = new JButton();
    JButton execToNewButton = new JButton();
    private final ImageIcon clearIcon = new ImageIcon(this.getClass().getResource("clear.gif"));
    private transient Vector spatialFunctionPanelListeners;
    private JPanel panelControl = new JPanel();
    private JCheckBox displayAAndBCheckBox = new JCheckBox();
    private JButton btnClearResult = new JButton();
    private JLabel lblDistance = new JLabel();
    private JTextField txtDistance = new JTextField();
    private JLabel lblQuadSegs = new JLabel();
    private JTextField txtQuadrantSegs = new JTextField();
    private JLabel lblCapStyle = new JLabel();
    private JComboBox cbCapStyle = new JComboBox();
    private JLabel lblJoinStyle = new JLabel();
    private JComboBox cbJoinStyle = new JComboBox();
    private JLabel lblMitreLimit = new JLabel();
    private JTextField txtMitreLimit = new JTextField();
    private GeometryFunction currentFunc = null;
    private Stopwatch timer;

    public SpatialFunctionPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.geomFuncPanel.populate(JTSTestBuilder.getFunctionRegistry().getCategorizedGeometryFunctions());
        this.setLayout(this.borderLayout1);
        this.panelParam.setLayout(this.gridLayout2);
        this.panelExec.setLayout(this.flowLayout);
        this.panelExecParam.setLayout(this.borderLayout2);
        this.panelRB.setLayout(this.gridLayout1);
        this.gridLayout2.setRows(5);
        this.gridLayout2.setColumns(2);
        this.displayAAndBCheckBox.setSelected(true);
        this.displayAAndBCheckBox.setToolTipText("");
        this.displayAAndBCheckBox.setText("Display Input Geometries");
        this.displayAAndBCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpatialFunctionPanel.this.displayAAndBCheckBox_actionPerformed(actionEvent);
            }
        });
        this.lblDistance.setText("Distance");
        this.txtDistance.setMaximumSize(new Dimension(25, Integer.MAX_VALUE));
        this.txtDistance.setMinimumSize(new Dimension(25, 21));
        this.txtDistance.setPreferredSize(new Dimension(25, 17));
        this.txtDistance.setText("10");
        this.txtDistance.setHorizontalAlignment(4);
        this.lblQuadSegs.setText("Quadrant Segs");
        this.txtQuadrantSegs.setHorizontalAlignment(4);
        this.lblCapStyle.setText("Cap Style");
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(capStyleItems);
        this.cbCapStyle.setModel(defaultComboBoxModel);
        this.lblJoinStyle.setText("Join Style");
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>(joinStyleItems);
        this.cbJoinStyle.setModel(defaultComboBoxModel2);
        this.lblMitreLimit.setText("Mitre Limit");
        this.txtMitreLimit.setHorizontalAlignment(4);
        this.panelControl.setLayout(this.flowLayout1);
        this.btnClearResult.setToolTipText("");
        this.btnClearResult.setMargin(new Insets(0, 10, 0, 10));
        this.btnClearResult.setSelected(true);
        this.btnClearResult.setText("Clear Result");
        this.btnClearResult.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpatialFunctionPanel.this.clearResultButton_actionPerformed(actionEvent);
            }
        });
        this.panelParam.add(this.lblDistance);
        this.panelParam.add(this.txtDistance);
        this.panelParam.add(this.lblQuadSegs);
        this.panelParam.add(this.txtQuadrantSegs);
        this.panelParam.add(this.lblCapStyle);
        this.panelParam.add(this.cbCapStyle);
        this.panelParam.add(this.lblJoinStyle);
        this.panelParam.add(this.cbJoinStyle);
        this.panelParam.add(this.lblMitreLimit);
        this.panelParam.add(this.txtMitreLimit);
        this.panelControl.add((Component)this.displayAAndBCheckBox, null);
        this.panelControl.add((Component)this.btnClearResult, null);
        this.execButton.setText("Compute");
        this.execButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpatialFunctionPanel.this.execButton_actionPerformed(actionEvent);
            }
        });
        this.execToNewButton.setText("Compute To New");
        this.execToNewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpatialFunctionPanel.this.execToNewButton_actionPerformed(actionEvent);
            }
        });
        this.panelExec.add(this.execButton);
        this.panelExecParam.add((Component)this.panelExec, "North");
        this.panelExecParam.add((Component)this.panelParam, "Center");
        this.panelExecParam.add((Component)this.panelControl, "South");
        this.add((Component)this.geomFuncPanel, "Center");
        this.add((Component)this.panelExecParam, "South");
        GeometryFunctionListener geometryFunctionListener = new GeometryFunctionListener(){

            public void functionSelected(GeometryFunctionEvent geometryFunctionEvent) {
                SpatialFunctionPanel.this.functionChanged(geometryFunctionEvent.getFunction());
            }

            public void functionInvoked(GeometryFunctionEvent geometryFunctionEvent) {
                SpatialFunctionPanel.this.execFunction(geometryFunctionEvent.getFunction());
            }
        };
        this.geomFuncPanel.addGeometryFunctionListener(geometryFunctionListener);
    }

    public void enableExecuteControl(boolean bl) {
        this.execButton.setEnabled(bl);
    }

    void clearResultButton_actionPerformed(ActionEvent actionEvent) {
        this.clearFunction();
    }

    void execButton_actionPerformed(ActionEvent actionEvent) {
        this.execFunction(this.geomFuncPanel.getFunction());
    }

    void execToNewButton_actionPerformed(ActionEvent actionEvent) {
        this.execFunction(this.geomFuncPanel.getFunction());
    }

    void displayAAndBCheckBox_actionPerformed(ActionEvent actionEvent) {
        this.getGeometryEditPanel().setShowingInput(this.displayAAndBCheckBox.isSelected());
    }

    private Geometry getGeometryA() {
        return JTSTestBuilder.model().getGeometryEditModel().getGeometry(0);
    }

    private Geometry getGeometryB() {
        return JTSTestBuilder.model().getGeometryEditModel().getGeometry(1);
    }

    private GeometryEditPanel getGeometryEditPanel() {
        return JTSTestBuilderFrame.instance().getTestCasePanel().getGeometryEditPanel();
    }

    private void setCurrentFunction(GeometryFunction geometryFunction) {
        this.currentFunc = geometryFunction;
        this.fireFunctionExecuted(new SpatialFunctionPanelEvent(this));
    }

    public void execFunction(GeometryFunction geometryFunction) {
        this.currentFunc = geometryFunction;
        if (this.currentFunc == null) {
            return;
        }
        this.fireFunctionExecuted(new SpatialFunctionPanelEvent(this));
    }

    private void functionChanged(GeometryFunction geometryFunction) {
        this.currentFunc = geometryFunction;
        this.updateParameterControls();
        this.execButton.setToolTipText("Compute " + this.functionDescription(geometryFunction));
    }

    private String functionDescription(GeometryFunction geometryFunction) {
        String string = "<b>" + geometryFunction.getSignature() + "</b>";
        String string2 = geometryFunction.getDescription();
        if (string2 != null) {
            string = string + "<br><br>" + string2;
        }
        return "<html>" + string + "</html>";
    }

    private void updateParameterControls() {
        int n = SpatialFunctionPanel.numNonGeomParams(this.currentFunc);
        SwingUtil.setEnabled(this.txtDistance, n >= 1);
        SwingUtil.setEnabled(this.txtQuadrantSegs, n >= 2);
        SwingUtil.setEnabled(this.cbCapStyle, n >= 3);
        SwingUtil.setEnabled(this.cbJoinStyle, n >= 4);
        SwingUtil.setEnabled(this.txtMitreLimit, n >= 5);
    }

    private static int numNonGeomParams(GeometryFunction geometryFunction) {
        int n = 0;
        Class[] classArray = geometryFunction.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] == Geometry.class) continue;
            ++n;
        }
        return n;
    }

    public boolean shouldShowGeometryA() {
        return this.displayAAndBCheckBox.isSelected();
    }

    public boolean shouldShowGeometryB() {
        return this.displayAAndBCheckBox.isSelected();
    }

    public void clearFunction() {
        this.setCurrentFunction(null);
    }

    public Object[] getFunctionParams() {
        Class[] classArray = this.currentFunc.getParameterTypes();
        if (classArray.length == 1 && classArray[0] == Geometry.class) {
            return new Object[]{this.getGeometryB()};
        }
        if (classArray.length == 1 && (classArray[0] == Double.class || classArray[0] == Double.TYPE)) {
            return new Object[]{SwingUtil.getDouble(this.txtDistance, null)};
        }
        if (classArray.length == 1 && (classArray[0] == Integer.class || classArray[0] == Integer.TYPE)) {
            return new Object[]{SwingUtil.getInteger(this.txtDistance, null)};
        }
        if (classArray.length == 1 && classArray[0] == String.class) {
            return new Object[]{this.txtDistance.getText()};
        }
        if (classArray.length == 2 && classArray[0] == Geometry.class && (classArray[1] == Double.class || classArray[1] == Double.TYPE)) {
            return new Object[]{this.getGeometryB(), SwingUtil.getDouble(this.txtDistance, null)};
        }
        if (classArray.length == 2 && classArray[0] == Geometry.class && (classArray[1] == Integer.class || classArray[1] == Integer.TYPE)) {
            return new Object[]{this.getGeometryB(), SwingUtil.getDouble(this.txtDistance, null)};
        }
        if (!(classArray.length != 2 || classArray[0] != Integer.class && classArray[0] != Integer.TYPE || classArray[1] != Double.class && classArray[1] != Double.TYPE)) {
            return new Object[]{SwingUtil.getInteger(this.txtDistance, new Integer(100)), SwingUtil.getDouble(this.txtQuadrantSegs, new Double(0.0))};
        }
        if (!(classArray.length != 2 || classArray[0] != Double.class && classArray[0] != Double.TYPE || classArray[1] != Integer.class && classArray[1] != Integer.TYPE)) {
            return new Object[]{SwingUtil.getDouble(this.txtDistance, new Double(10.0)), SwingUtil.getInteger(this.txtQuadrantSegs, new Integer(0))};
        }
        if (classArray.length >= 2) {
            return new Object[]{SwingUtil.getDouble(this.txtDistance, null), SwingUtil.getInteger(this.txtQuadrantSegs, null), SwingUtil.getSelectedValue(this.cbCapStyle, capStyleValues), SwingUtil.getSelectedValue(this.cbJoinStyle, joinStyleValues), SwingUtil.getDouble(this.txtMitreLimit, null)};
        }
        return null;
    }

    public boolean isFunctionSelected() {
        return this.currentFunc != null;
    }

    public String getFunctionCall() {
        if (this.currentFunc == null) {
            return null;
        }
        return this.currentFunc.getCategory() + "." + this.currentFunc.getName() + "(" + FunctionParameters.toString(this.getFunctionParams()) + ")";
    }

    public GeometryFunction getFunction() {
        return this.currentFunc;
    }

    public synchronized void removeSpatialFunctionPanelListener(SpatialFunctionPanelListener spatialFunctionPanelListener) {
        if (this.spatialFunctionPanelListeners != null && this.spatialFunctionPanelListeners.contains(spatialFunctionPanelListener)) {
            Vector vector = (Vector)this.spatialFunctionPanelListeners.clone();
            vector.removeElement(spatialFunctionPanelListener);
            this.spatialFunctionPanelListeners = vector;
        }
    }

    public synchronized void addSpatialFunctionPanelListener(SpatialFunctionPanelListener spatialFunctionPanelListener) {
        Vector vector;
        Vector vector2 = vector = this.spatialFunctionPanelListeners == null ? new Vector(2) : (Vector)this.spatialFunctionPanelListeners.clone();
        if (!vector.contains(spatialFunctionPanelListener)) {
            vector.addElement(spatialFunctionPanelListener);
            this.spatialFunctionPanelListeners = vector;
        }
    }

    protected void fireFunctionExecuted(SpatialFunctionPanelEvent spatialFunctionPanelEvent) {
        if (this.spatialFunctionPanelListeners != null) {
            Vector vector = this.spatialFunctionPanelListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SpatialFunctionPanelListener)vector.elementAt(i)).functionExecuted(spatialFunctionPanelEvent);
            }
        }
    }
}

