/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.controller;

import com.vividsolutions.jts.util.Stopwatch;
import com.vividsolutions.jtstest.function.GeometryFunction;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilder;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.SpatialFunctionPanelEvent;
import com.vividsolutions.jtstest.testbuilder.controller.JTSTestBuilderController;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import com.vividsolutions.jtstest.testbuilder.ui.SwingWorker;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.Timer;

public class ResultController {
    private static NumberFormat timeFmt = NumberFormat.getNumberInstance();
    JTSTestBuilderFrame frame;
    TestBuilderModel model = null;
    private SwingWorker worker = null;
    private Timer funcTimer;
    private long runMillis = 0L;
    private static final int TIMER_DELAY_IN_MILLIS = 10;

    public ResultController(JTSTestBuilderFrame jTSTestBuilderFrame) {
        this.frame = jTSTestBuilderFrame;
        this.model = JTSTestBuilder.model();
    }

    public void spatialFunctionPanel_functionExecuted(SpatialFunctionPanelEvent spatialFunctionPanelEvent) {
        this.model.setOpName(this.frame.getTestCasePanel().getSpatialFunctionPanel().getFunctionCall());
        this.frame.getResultWKTPanel().setOpName(this.model.getOpName());
        this.clearResult();
        if (!this.frame.getTestCasePanel().getSpatialFunctionPanel().isFunctionSelected()) {
            return;
        }
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        this.frame.getTestCasePanel().getSpatialFunctionPanel().enableExecuteControl(false);
        this.startFunctionMonitor();
        this.runFunctionWorker();
        this.frame.showResultWKTTab();
    }

    private void clearResult() {
        this.frame.getResultWKTPanel().clearResult();
        this.updateResult(null, null);
    }

    private void updateResult(Object object, Stopwatch stopwatch) {
        this.model.setResult(object);
        String string = stopwatch != null ? stopwatch.getTimeString() : "";
        this.frame.getResultWKTPanel().setExecutedTime(string);
        this.frame.getResultWKTPanel().updateResult();
        JTSTestBuilderController.geometryViewChanged();
        this.frame.getTestCasePanel().getSpatialFunctionPanel().enableExecuteControl(true);
        this.frame.setCursor(Cursor.getPredefinedCursor(0));
        if (object != null) {
            JTSTestBuilderFrame.instance().displayInfo(this.frame.getTestCasePanel().getSpatialFunctionPanel().getFunctionCall() + " : " + string, false);
        }
    }

    private void runFunctionWorker() {
        this.worker = new SwingWorker(){
            Stopwatch timer;

            public Object construct() {
                return this.computeResult();
            }

            private Object computeResult() {
                Object object = null;
                GeometryFunction geometryFunction = ResultController.this.frame.getTestCasePanel().getSpatialFunctionPanel().getFunction();
                if (geometryFunction == null) {
                    return null;
                }
                try {
                    this.timer = new Stopwatch();
                    object = geometryFunction.invoke(ResultController.this.model.getGeometryEditModel().getGeometry(0), ResultController.this.frame.getTestCasePanel().getSpatialFunctionPanel().getFunctionParams());
                    this.timer.stop();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                    object = exception;
                }
                return object;
            }

            public void finished() {
                ResultController.this.stopFunctionMonitor();
                ResultController.this.updateResult(this.getValue(), this.timer);
                ResultController.this.worker = null;
            }
        };
        this.worker.start();
    }

    private void clearFunctionWorker() {
    }

    private void startFunctionMonitor() {
        this.runMillis = 0L;
        this.funcTimer = new Timer(10, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultController.this.runMillis += 10L;
                String string = "";
                string = ResultController.this.runMillis < 10000L ? ResultController.this.runMillis + " ms" : timeFmt.format((double)ResultController.this.runMillis / 1000.0) + " s";
                ResultController.this.frame.getResultWKTPanel().setRunningTime(string);
            }
        });
        this.funcTimer.setInitialDelay(0);
        this.funcTimer.start();
    }

    private void stopFunctionMonitor() {
        this.funcTimer.stop();
    }

    public void scalarFunctionPanel_functionExecuted(SpatialFunctionPanelEvent spatialFunctionPanelEvent) {
        String string = this.frame.getTestCasePanel().getScalarFunctionPanel().getOpName();
        this.frame.getResultValuePanel().setResult(string, "", null);
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        Object object = this.frame.getTestCasePanel().getScalarFunctionPanel().getResult();
        Stopwatch stopwatch = this.frame.getTestCasePanel().getScalarFunctionPanel().getTimer();
        this.frame.setCursor(Cursor.getPredefinedCursor(0));
        this.frame.getResultValuePanel().setResult(string, stopwatch.getTimeString(), object);
        this.frame.showResultValueTab();
    }

    static {
        timeFmt.setMinimumFractionDigits(3);
    }
}

