/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jtstest.testbuilder.geom.GeometryLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public class FacetLocater {
    private Geometry parentGeom;
    private List locations = new ArrayList();
    private Coordinate queryPt;
    private double tolerance = 0.0;

    public static List filterVertexLocations(Collection collection) {
        ArrayList<GeometryLocation> arrayList = new ArrayList<GeometryLocation>();
        for (GeometryLocation geometryLocation : collection) {
            if (!geometryLocation.isVertex()) continue;
            arrayList.add(geometryLocation);
        }
        return arrayList;
    }

    public FacetLocater(Geometry geometry) {
        this.parentGeom = geometry;
    }

    public List getLocations(Coordinate coordinate, double d) {
        this.queryPt = coordinate;
        this.tolerance = d;
        this.findLocations(this.parentGeom, this.locations);
        return this.locations;
    }

    private void findLocations(Geometry geometry, List list) {
        this.findLocations(new Stack(), this.parentGeom, list);
    }

    private void findLocations(Stack stack, Geometry geometry, List list) {
        if (geometry instanceof GeometryCollection) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                Geometry geometry2 = geometry.getGeometryN(i);
                stack.push(new Integer(i));
                this.findLocations(stack, geometry2, list);
                stack.pop();
            }
        } else if (geometry instanceof Polygon) {
            this.findLocations(stack, (Polygon)geometry, list);
        } else {
            CoordinateSequence coordinateSequence;
            if (geometry instanceof LineString) {
                coordinateSequence = ((LineString)geometry).getCoordinateSequence();
            } else if (geometry instanceof Point) {
                coordinateSequence = ((Point)geometry).getCoordinateSequence();
            } else {
                throw new IllegalStateException("Unknown geometry type: " + geometry.getClass().getName());
            }
            this.findLocations(stack, geometry, coordinateSequence, list);
        }
    }

    private void findLocations(Stack stack, Polygon polygon, List list) {
        stack.push(new Integer(0));
        this.findLocations(stack, (Geometry)polygon.getExteriorRing(), polygon.getExteriorRing().getCoordinateSequence(), list);
        stack.pop();
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            stack.push(new Integer(i + 1));
            this.findLocations(stack, (Geometry)polygon.getInteriorRingN(i), polygon.getInteriorRingN(i).getCoordinateSequence(), list);
            stack.pop();
        }
    }

    private void findLocations(Stack stack, Geometry geometry, CoordinateSequence coordinateSequence, List list) {
        this.findVertexLocations(stack, geometry, coordinateSequence, list);
        this.findSegmentLocations(stack, geometry, coordinateSequence, list);
    }

    private void findVertexLocations(Stack stack, Geometry geometry, CoordinateSequence coordinateSequence, List list) {
        for (int i = 0; i < coordinateSequence.size(); ++i) {
            Coordinate coordinate = coordinateSequence.getCoordinate(i);
            double d = coordinate.distance(this.queryPt);
            if (!(d <= this.tolerance)) continue;
            list.add(new GeometryLocation(this.parentGeom, geometry, FacetLocater.toIntArray(stack), i, true, coordinate));
        }
    }

    private void findSegmentLocations(Stack stack, Geometry geometry, CoordinateSequence coordinateSequence, List list) {
        LineSegment lineSegment = new LineSegment();
        for (int i = 0; i < coordinateSequence.size() - 1; ++i) {
            lineSegment.p0 = coordinateSequence.getCoordinate(i);
            lineSegment.p1 = coordinateSequence.getCoordinate(i + 1);
            double d = lineSegment.distance(this.queryPt);
            if (!(d <= this.tolerance)) continue;
            list.add(new GeometryLocation(this.parentGeom, geometry, FacetLocater.toIntArray(stack), i, false, lineSegment.p0));
        }
    }

    public static int[] toIntArray(Vector vector) {
        int[] nArray = new int[vector.size()];
        int n = 0;
        for (Integer n2 : vector) {
            nArray[n++] = n2;
        }
        return nArray;
    }
}

