/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.model;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jtstest.test.TestCaseList;
import com.vividsolutions.jtstest.test.Testable;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import com.vividsolutions.jtstest.util.StringUtil;

public class JavaTestWriter {
    private WKTWriter writer = new WKTWriter();

    public static String getRunJava(String string, TestBuilderModel testBuilderModel) {
        return "package com.vividsolutions.jtstest.testsuite;" + StringUtil.newLine + "" + StringUtil.newLine + "import com.vividsolutions.jtstest.test.*;" + StringUtil.newLine + "" + StringUtil.newLine + "public class " + string + " extends TestCaseList {" + StringUtil.newLine + "  public static void main(String[] args) {" + StringUtil.newLine + "    " + string + " test = new " + string + "();" + StringUtil.newLine + "    test.run();" + StringUtil.newLine + "  }" + StringUtil.newLine + "" + StringUtil.newLine + "  public " + string + "() {" + StringUtil.newLine + JavaTestWriter.getTestJava(testBuilderModel.getTestCaseList()) + "  }" + StringUtil.newLine + "}";
    }

    public static String getTestJava(TestCaseList testCaseList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < testCaseList.getList().size(); ++i) {
            stringBuffer.append(new JavaTestWriter().write((Testable)testCaseList.getList().get(i)));
        }
        return stringBuffer.toString();
    }

    public String write(Testable testable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    add(new TestCase(\n");
        String string = testable.getName() == null ? "" : testable.getName();
        String string2 = testable.getDescription() == null ? "" : testable.getDescription();
        String string3 = testable.getGeometry(0) == null ? null : this.writer.write(testable.getGeometry(0));
        String string4 = testable.getGeometry(1) == null ? null : this.writer.write(testable.getGeometry(1));
        String string5 = testable.getExpectedIntersectionMatrix() != null ? testable.getExpectedIntersectionMatrix().toString() : null;
        stringBuffer.append("          \"" + string + "\",\n");
        stringBuffer.append("          \"" + string2 + "\",\n");
        stringBuffer.append("          " + (string3 == null ? "null" : "\"" + string3 + "\"") + ",\n");
        stringBuffer.append("          " + (string4 == null ? "null" : "\"" + string4 + "\"") + ",\n");
        stringBuffer.append("          " + (string5 == null ? "null" : "\"" + string5 + "\"") + ",\n");
        stringBuffer.append("          " + this.write(testable.getExpectedConvexHull()) + ",\n");
        stringBuffer.append("          " + this.write(testable.getExpectedIntersection()) + ",\n");
        stringBuffer.append("          " + this.write(testable.getExpectedUnion()) + ",\n");
        stringBuffer.append("          " + this.write(testable.getExpectedDifference()) + ",\n");
        stringBuffer.append("          " + this.write(testable.getExpectedSymDifference()) + ",\n");
        stringBuffer.append("          " + this.write(testable.getExpectedBoundary()) + "));\n");
        return stringBuffer.toString();
    }

    private String write(Geometry geometry) {
        if (geometry == null) {
            return "null";
        }
        return "\"" + this.writer.write(geometry) + "\"";
    }
}

