/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.model;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jtstest.test.TestCase;
import com.vividsolutions.jtstest.test.Testable;

public class TestCaseEdit
implements Testable {
    private Geometry[] geom = new Geometry[2];
    private Testable testable;
    private String opName = "";
    private Geometry resultGeom = null;

    public TestCaseEdit(PrecisionModel precisionModel) {
        TestCase testCase = new TestCase();
        testCase.setPrecisionModel(precisionModel);
        this.testable = testCase;
    }

    public TestCaseEdit(Testable testable) throws ParseException {
        this.testable = testable;
        this.testable.initGeometry();
        this.setGeometry(0, this.testable.getGeometry(0));
        this.setGeometry(1, this.testable.getGeometry(1));
    }

    public TestCaseEdit(TestCaseEdit testCaseEdit) {
        this.testable = new TestCase();
        this.setGeometry(0, testCaseEdit.getGeometry(0));
        this.setGeometry(1, testCaseEdit.getGeometry(1));
    }

    public TestCaseEdit(Geometry[] geometryArray) {
        this.testable = new TestCase();
        this.setGeometry(0, geometryArray[0]);
        this.setGeometry(1, geometryArray[1]);
    }

    public TestCaseEdit(Geometry[] geometryArray, String string) {
        this.testable = new TestCase();
        this.setGeometry(0, geometryArray[0]);
        this.setGeometry(1, geometryArray[1]);
        this.testable.setName(string);
    }

    private static Geometry cloneGeometry(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        return (Geometry)geometry.clone();
    }

    public void setGeometry(int n, Geometry geometry) {
        this.testable.setGeometry(n, geometry);
    }

    public void setIntersectionMatrix(IntersectionMatrix intersectionMatrix) {
        this.testable.setIntersectionMatrix(intersectionMatrix);
    }

    public void setName(String string) {
        this.testable.setName(string);
    }

    public Geometry getResult() {
        return this.resultGeom;
    }

    public void setResult(Geometry geometry) {
        this.resultGeom = geometry;
    }

    public String getOpName() {
        return this.opName;
    }

    public void setOpName(String string) {
        this.opName = string;
    }

    public void setExpectedIntersectionMatrix(String string) {
        this.testable.setExpectedIntersectionMatrix(string);
    }

    public void setExpectedConvexHull(Geometry geometry) {
        this.testable.setExpectedConvexHull(geometry);
    }

    public void setExpectedBoundary(Geometry geometry) {
        this.testable.setExpectedBoundary(geometry);
    }

    public void setExpectedIntersection(Geometry geometry) {
        this.testable.setExpectedIntersection(geometry);
    }

    public void setExpectedUnion(Geometry geometry) {
        this.testable.setExpectedUnion(geometry);
    }

    public void setExpectedDifference(Geometry geometry) {
        this.testable.setExpectedDifference(geometry);
    }

    public void setExpectedSymDifference(Geometry geometry) {
        this.testable.setExpectedSymDifference(geometry);
    }

    public void setExpectedCentroid(Geometry geometry) {
        this.testable.setExpectedCentroid(geometry);
    }

    public Geometry getGeometry(int n) {
        return this.testable.getGeometry(n);
    }

    public IntersectionMatrix getIM() {
        this.runRelate();
        return this.testable.getIntersectionMatrix();
    }

    public Testable getTestable() {
        return this.testable;
    }

    public boolean isFailed() {
        return this.testable.isFailed();
    }

    public String getFailedMsg() {
        return this.testable.getFailedMsg();
    }

    public String getName() {
        return this.testable.getName();
    }

    public IntersectionMatrix getIntersectionMatrix() {
        return this.testable.getIntersectionMatrix();
    }

    public String getDescription() {
        return this.testable.getDescription();
    }

    public boolean isPassed() {
        return this.testable.isPassed();
    }

    public String getWellKnownText(int n) {
        return this.testable.getWellKnownText(n);
    }

    public String getExpectedIntersectionMatrix() {
        return this.testable.getExpectedIntersectionMatrix();
    }

    public Geometry getExpectedConvexHull() {
        return this.testable.getExpectedConvexHull();
    }

    public Geometry getExpectedBoundary() {
        return this.testable.getExpectedBoundary();
    }

    public Geometry getExpectedIntersection() {
        return this.testable.getExpectedIntersection();
    }

    public Geometry getExpectedUnion() {
        return this.testable.getExpectedUnion();
    }

    public Geometry getExpectedDifference() {
        return this.testable.getExpectedDifference();
    }

    public Geometry getExpectedSymDifference() {
        return this.testable.getExpectedSymDifference();
    }

    public void exchange() {
        Geometry geometry = this.testable.getGeometry(0);
        this.testable.setGeometry(0, this.testable.getGeometry(1));
        this.testable.setGeometry(1, geometry);
    }

    public void runTest() throws ParseException {
        this.testable.runTest();
    }

    public void initGeometry() throws ParseException {
        this.testable.initGeometry();
    }

    public Geometry[] getGeometries() {
        return new Geometry[]{this.testable.getGeometry(0), this.testable.getGeometry(1)};
    }

    void runRelate() {
        Geometry[] geometryArray = this.getGeometries();
        if (geometryArray[0] == null || geometryArray[1] == null) {
            return;
        }
        this.testable.setIntersectionMatrix(geometryArray[0].relate(geometryArray[1]));
    }
}

