/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.model;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Lineal;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.Puntal;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jtstest.test.TestCase;
import com.vividsolutions.jtstest.test.TestCaseList;
import com.vividsolutions.jtstest.test.Testable;
import com.vividsolutions.jtstest.testbuilder.model.TestCaseEdit;
import com.vividsolutions.jtstest.testbuilder.model.TestRunnerTestCaseAdapter;
import com.vividsolutions.jtstest.util.StringUtil;
import java.io.File;

public class XMLTestWriter {
    private WKTWriter wktWriter = new WKTWriter();

    public static String toXML(PrecisionModel precisionModel) {
        if (precisionModel.isFloating()) {
            return "<precisionModel type=\"FLOATING\"/>";
        }
        return "<precisionModel type=\"FIXED\" scale=\"" + precisionModel.getScale() + "\"/>";
    }

    public String getTestXML(Geometry geometry, String string, String[] stringArray) {
        String string2 = "  <test>\n";
        string2 = string2 + "    <op name=\"" + string + "\" arg1=\"A\"";
        int n = 2;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            Assert.isTrue((string3 != null ? 1 : 0) != 0);
            string2 = string2 + " arg" + n + "=\"" + string3 + "\"";
            ++n;
        }
        string2 = string2 + ">\n";
        string2 = string2 + StringUtil.indent(this.wktWriter.writeFormatted(geometry) + "\n", 6);
        string2 = string2 + "    </op>\n";
        string2 = string2 + "  </test>\n";
        return string2;
    }

    private boolean isGdbcTestCase(TestCase testCase) {
        if (testCase.getName() == null || testCase.getDescription() == null) {
            return false;
        }
        if (testCase.getName().equalsIgnoreCase(testCase.getDescription())) {
            return false;
        }
        int n = testCase.getName().indexOf(":");
        int n2 = testCase.getDescription().indexOf(":");
        if (n == -1 || n2 == -1) {
            return false;
        }
        return n == n2;
    }

    public String getDescriptionForXmlFromGdbcTestCase(TestCase testCase) {
        int n = testCase.getDescription().indexOf(":");
        return "<desc>" + StringUtil.escapeHTML(testCase.getName() + " [" + testCase.getDescription().substring(1 + n).trim() + "]") + "</desc>\n";
    }

    public String getDescriptionForXml(TestCase testCase) {
        if (this.isGdbcTestCase(testCase)) {
            return this.getDescriptionForXmlFromGdbcTestCase(testCase);
        }
        if (testCase.getDescription() != null && testCase.getDescription().length() > 0) {
            return "<desc>" + StringUtil.escapeHTML(testCase.getDescription()) + "</desc>\n";
        }
        if (testCase.getName() != null && testCase.getName().length() > 0) {
            return "<desc>" + StringUtil.escapeHTML(testCase.getName()) + "</desc>\n";
        }
        return "<desc> " + this.getGeometryArgPairCode(testCase.getGeometries()) + " </desc>\n";
    }

    private String getGeometryArgPairCode(Geometry[] geometryArray) {
        return this.getGeometryCode(geometryArray[0]) + "/" + this.getGeometryCode(geometryArray[1]);
    }

    private String getGeometryCode(Geometry geometry) {
        String string = "";
        if (geometry instanceof Puntal) {
            string = "P";
        }
        if (geometry instanceof Lineal) {
            string = "L";
        }
        if (geometry instanceof Polygonal) {
            string = "L";
        }
        if (geometry instanceof GeometryCollection) {
            return "m" + string;
        }
        return string;
    }

    public String getTestXML(TestRunnerTestCaseAdapter testRunnerTestCaseAdapter) {
        return testRunnerTestCaseAdapter.getTestRunnerTestCase().toXml();
    }

    public String getTestXML(Testable testable) {
        if (testable instanceof TestCase) {
            return this.getTestXML((TestCase)testable);
        }
        if (testable instanceof TestCaseEdit) {
            return this.getTestXML(((TestCaseEdit)testable).getTestable());
        }
        if (testable instanceof TestRunnerTestCaseAdapter) {
            return this.getTestXML((TestRunnerTestCaseAdapter)testable);
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public String getTestXML(TestCase testCase) {
        String string;
        Geometry[] geometryArray = testCase.getGeometries();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<case>\n");
        stringBuffer.append(this.getDescriptionForXml(testCase));
        if (geometryArray[0] != null) {
            string = this.wktWriter.writeFormatted(geometryArray[0]);
            stringBuffer.append("  <a> " + string + "\n    </a>\n");
        }
        if (geometryArray[1] != null) {
            string = this.wktWriter.writeFormatted(geometryArray[1]);
            stringBuffer.append("  <b> " + string + "\n    </b>\n");
        }
        if (testCase.getExpectedIntersectionMatrix() != null) {
            stringBuffer.append("  <test>\n");
            stringBuffer.append("    <op name=\"relate\" arg1=\"A\" arg2=\"B\" arg3=\"" + testCase.getExpectedIntersectionMatrix() + "\">true</op>\n");
            stringBuffer.append("  </test>\n");
        }
        if (testCase.getExpectedBoundary() != null) {
            stringBuffer.append(this.getTestXML(testCase.getExpectedBoundary(), "getboundary", new String[0]));
        }
        if (testCase.getExpectedConvexHull() != null) {
            stringBuffer.append(this.getTestXML(testCase.getExpectedConvexHull(), "convexhull", new String[0]));
        }
        if (testCase.getExpectedIntersection() != null) {
            stringBuffer.append(this.getTestXML(testCase.getExpectedIntersection(), "intersection", new String[]{"B"}));
        }
        if (testCase.getExpectedUnion() != null) {
            stringBuffer.append(this.getTestXML(testCase.getExpectedUnion(), "union", new String[]{"B"}));
        }
        if (testCase.getExpectedDifference() != null) {
            stringBuffer.append(this.getTestXML(testCase.getExpectedDifference(), "difference", new String[]{"B"}));
        }
        if (testCase.getExpectedSymDifference() != null) {
            stringBuffer.append(this.getTestXML(testCase.getExpectedSymDifference(), "symdifference", new String[]{"B"}));
        }
        stringBuffer.append("</case>\n");
        return stringBuffer.toString();
    }

    public String getTestXML(TestCaseList testCaseList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < testCaseList.getList().size(); ++i) {
            stringBuffer.append("\n");
            stringBuffer.append(this.getTestXML((Testable)testCaseList.getList().get(i)));
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static String getRunXml(TestCaseList testCaseList, PrecisionModel precisionModel) {
        String string = "<run>" + StringUtil.newLine;
        string = string + XMLTestWriter.getRunDescription(testCaseList);
        string = string + XMLTestWriter.getRunWorkspace(testCaseList);
        string = string + XMLTestWriter.toXML(precisionModel) + StringUtil.newLine;
        string = string + new XMLTestWriter().getTestXML(testCaseList) + "</run>";
        return string;
    }

    public static String getRunDescription(TestCaseList testCaseList) {
        for (TestCaseEdit testCaseEdit : testCaseList.getList()) {
            if (!(testCaseEdit.getTestable() instanceof TestRunnerTestCaseAdapter)) continue;
            TestRunnerTestCaseAdapter testRunnerTestCaseAdapter = (TestRunnerTestCaseAdapter)testCaseEdit.getTestable();
            String string = testRunnerTestCaseAdapter.getTestRunnerTestCase().getTestRun().getDescription();
            if (string != null && string.length() > 0) {
                return "  <desc>" + StringUtil.escapeHTML(string) + "</desc>" + StringUtil.newLine;
            }
            return "";
        }
        return "";
    }

    public static String getRunWorkspace(TestCaseList testCaseList) {
        for (TestCaseEdit testCaseEdit : testCaseList.getList()) {
            if (!(testCaseEdit.getTestable() instanceof TestRunnerTestCaseAdapter)) continue;
            TestRunnerTestCaseAdapter testRunnerTestCaseAdapter = (TestRunnerTestCaseAdapter)testCaseEdit.getTestable();
            File file = testRunnerTestCaseAdapter.getTestRunnerTestCase().getTestRun().getWorkspace();
            if (file != null) {
                return "  <workspace file=\"" + StringUtil.escapeHTML(file.toString()) + "\"/>" + StringUtil.newLine;
            }
            return "";
        }
        return "";
    }
}

