/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.topostretch;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jtstest.testbuilder.topostretch.StretchedVertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class StretchedVertexFinder {
    private Collection linestrings;
    private double tolerance = 0.0;
    private Envelope limitEnv = null;
    private List nearVerts = new ArrayList();
    private static LineSegment distSeg = new LineSegment();

    public static List findNear(Collection collection, double d, Envelope envelope) {
        StretchedVertexFinder stretchedVertexFinder = new StretchedVertexFinder(collection, d, envelope);
        return stretchedVertexFinder.getNearVertices();
    }

    public StretchedVertexFinder(Collection collection, double d) {
        this.linestrings = collection;
        this.tolerance = d;
    }

    public StretchedVertexFinder(Collection collection, double d, Envelope envelope) {
        this(collection, d);
        this.limitEnv = envelope;
    }

    public List getNearVertices() {
        this.findNearVertices();
        return this.nearVerts;
    }

    private void findNearVertices() {
        for (LineString lineString : this.linestrings) {
            this.findNearVertices(lineString);
        }
    }

    private static int geomPointsLen(Coordinate[] coordinateArray) {
        int n = coordinateArray.length;
        if (CoordinateArrays.isRing((Coordinate[])coordinateArray)) {
            n = coordinateArray.length - 1;
        }
        return n;
    }

    private void findNearVertices(LineString lineString) {
        Coordinate[] coordinateArray = lineString.getCoordinates();
        int n = StretchedVertexFinder.geomPointsLen(coordinateArray);
        for (int i = 0; i < n; ++i) {
            if (!this.limitEnv.intersects(coordinateArray[i])) continue;
            this.findNearVertex(coordinateArray, i);
        }
    }

    private void findNearVertex(Coordinate[] coordinateArray, int n) {
        for (LineString lineString : this.linestrings) {
            this.findNearVertex(coordinateArray, n, lineString);
        }
    }

    private void findNearVertex(Coordinate[] coordinateArray, int n, LineString lineString) {
        Coordinate coordinate = coordinateArray[n];
        Coordinate[] coordinateArray2 = lineString.getCoordinates();
        int n2 = StretchedVertexFinder.geomPointsLen(coordinateArray2);
        for (int i = 0; i < n2; ++i) {
            Coordinate coordinate2 = coordinateArray2[i];
            StretchedVertex stretchedVertex = null;
            double d = coordinate2.distance(coordinate);
            if (d <= this.tolerance && d != 0.0) {
                stretchedVertex = new StretchedVertex(coordinate, coordinateArray, n, coordinate2, coordinateArray2, i);
            } else if (i < coordinateArray2.length - 1) {
                Coordinate coordinate3 = coordinateArray2[i + 1];
                double d2 = coordinate3.distance(coordinate);
                if (d2 <= this.tolerance) continue;
                if (StretchedVertexFinder.isPointNearButNotOnSeg(coordinate, coordinate2, coordinate3, this.tolerance)) {
                    stretchedVertex = new StretchedVertex(coordinate, coordinateArray, i, new LineSegment(coordinate2, coordinateArray2[i + 1]));
                }
            }
            if (stretchedVertex == null) continue;
            this.nearVerts.add(stretchedVertex);
        }
    }

    private static boolean contains(Envelope envelope, Coordinate coordinate, Coordinate coordinate2) {
        if (!envelope.contains(coordinate)) {
            return false;
        }
        return envelope.contains(coordinate2);
    }

    private static boolean isPointNearButNotOnSeg(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, double d) {
        if (CGAlgorithms.computeOrientation((Coordinate)coordinate2, (Coordinate)coordinate3, (Coordinate)coordinate) == 0) {
            return false;
        }
        StretchedVertexFinder.distSeg.p0 = coordinate2;
        StretchedVertexFinder.distSeg.p1 = coordinate3;
        double d2 = distSeg.distance(coordinate);
        return !(d2 > d);
    }

    private static double distanceToSeg(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        StretchedVertexFinder.distSeg.p0 = coordinate2;
        StretchedVertexFinder.distSeg.p1 = coordinate3;
        double d = distSeg.distance(coordinate);
        if (CGAlgorithms.computeOrientation((Coordinate)coordinate2, (Coordinate)coordinate3, (Coordinate)coordinate) == 0) {
            d = 0.0;
        }
        return d;
    }
}

