/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.render;

import com.vividsolutions.jts.awt.PointShapeFactory;
import com.vividsolutions.jts.awt.PointTransformation;
import com.vividsolutions.jts.awt.ShapeWriter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jtstest.testbuilder.Viewport;
import com.vividsolutions.jtstest.testbuilder.ui.style.Style;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;

public class GeometryPainter {
    private static Stroke GEOMETRY_STROKE = new BasicStroke();
    private static Stroke POINT_STROKE = new BasicStroke(5.0f);
    static Viewport viewportCache;
    static ShapeWriter converterCache;

    public static void paint(Graphics2D graphics2D, Viewport viewport, Geometry geometry, Style style) throws Exception {
        if (geometry == null) {
            return;
        }
        if (!viewport.intersectsInModel(geometry.getEnvelopeInternal())) {
            return;
        }
        if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                GeometryPainter.paint(graphics2D, viewport, geometryCollection.getGeometryN(i), style);
            }
            return;
        }
        style.paint(geometry, viewport, graphics2D);
    }

    private static void paintGeometryCollection(Graphics2D graphics2D, Viewport viewport, GeometryCollection geometryCollection, Style style) throws Exception {
    }

    public static ShapeWriter BADgetConverter(Viewport viewport) {
        if (viewportCache != viewport) {
            viewportCache = viewport;
            converterCache = new ShapeWriter((PointTransformation)viewport, (PointShapeFactory)new PointShapeFactory.Point());
        }
        return converterCache;
    }

    public static ShapeWriter getConverter(Viewport viewport) {
        return new ShapeWriter((PointTransformation)viewport, (PointShapeFactory)new PointShapeFactory.Point());
    }

    public static void paint(Geometry geometry, Viewport viewport, Graphics2D graphics2D, Color color, Color color2) {
        GeometryPainter.paint(geometry, viewport, graphics2D, color, color2, null);
    }

    public static void paint(Geometry geometry, Viewport viewport, Graphics2D graphics2D, Color color, Color color2, Stroke stroke) {
        ShapeWriter shapeWriter = GeometryPainter.getConverter(viewport);
        GeometryPainter.paint(geometry, shapeWriter, graphics2D, color, color2, stroke);
    }

    private static void paint(Geometry geometry, ShapeWriter shapeWriter, Graphics2D graphics2D, Color color, Color color2) {
        GeometryPainter.paint(geometry, shapeWriter, graphics2D, color, color2, null);
    }

    private static void paint(Geometry geometry, ShapeWriter shapeWriter, Graphics2D graphics2D, Color color, Color color2, Stroke stroke) {
        if (geometry == null) {
            return;
        }
        if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                GeometryPainter.paint(geometryCollection.getGeometryN(i), shapeWriter, graphics2D, color, color2, stroke);
            }
            return;
        }
        Shape shape = shapeWriter.toShape(geometry);
        if (geometry instanceof Point) {
            graphics2D.setStroke(POINT_STROKE);
            graphics2D.setColor(color);
            graphics2D.draw(shape);
            return;
        }
        if (stroke == null) {
            graphics2D.setStroke(GEOMETRY_STROKE);
        } else {
            graphics2D.setStroke(stroke);
        }
        if (geometry instanceof Polygon && color2 != null) {
            graphics2D.setPaint(color2);
            graphics2D.fill(shape);
        }
        if (color != null) {
            graphics2D.setColor(color);
            try {
                graphics2D.draw(shape);
            }
            catch (Throwable throwable) {
                System.out.println(throwable);
            }
        }
    }
}

