/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.render;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.math.MathUtil;
import com.vividsolutions.jtstest.testbuilder.AppConstants;
import com.vividsolutions.jtstest.testbuilder.Viewport;
import com.vividsolutions.jtstest.testbuilder.model.DrawingGrid;
import com.vividsolutions.jtstest.testbuilder.ui.ColorUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.NumberFormat;

public class GridRenderer {
    private static final int MIN_VIEW_GRID_SIZE = 5;
    private Viewport viewport;
    private DrawingGrid grid;
    private boolean isEnabled = true;
    private NumberFormat gridSizeFormat;
    private static final Coordinate MODEL_ORIGIN = new Coordinate(0.0, 0.0);
    private static final int GRID_MAJOR_LINE_CLR = 220;
    private static final int GRID_MINOR_LINE_CLR = 240;
    private static final int TICK_LEN = 5;
    private static final int SCALE_TEXT_OFFSET_X = 40;
    private static final int SCALE_TEXT_OFFSET_Y = 2;

    public GridRenderer(Viewport viewport, DrawingGrid drawingGrid) {
        this.viewport = viewport;
        this.grid = drawingGrid;
        this.gridSizeFormat = NumberFormat.getInstance();
        this.gridSizeFormat.setGroupingUsed(false);
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public void paint(Graphics2D graphics2D) {
        if (!this.isEnabled) {
            return;
        }
        this.drawAxes(graphics2D);
        this.drawLinedGrid(graphics2D);
        this.drawGridSizeLabel(graphics2D, this.viewport.gridMagnitudeModel());
    }

    private boolean isResolvable() {
        Point2D point2D = this.viewport.toModel(new Point(0, 0));
        Point2D point2D2 = this.viewport.toModel(new Point(5, 0));
        return this.grid.isResolvable(point2D, point2D2);
    }

    private void drawAxes(Graphics2D graphics2D) {
        graphics2D.setColor(AppConstants.AXIS_CLR);
        graphics2D.setStroke(new BasicStroke(3.0f));
        Point2D point2D = this.viewport.toView(MODEL_ORIGIN);
        double d = point2D.getX();
        double d2 = point2D.getY();
        if (d >= 0.0 && d <= this.viewport.getWidthInView()) {
            graphics2D.draw(new Line2D.Double(d, 0.0, d, this.viewport.getHeightInView()));
        }
        if (d2 >= 0.0 && d2 <= this.viewport.getHeightInView()) {
            graphics2D.draw(new Line2D.Double(0.0, d2, this.viewport.getWidthInView(), d2));
        }
    }

    private int maxVisibleMagnitude() {
        double d = this.viewport.getModelEnv().maxExtent();
        if (d <= 0.0) {
            return 1;
        }
        double d2 = MathUtil.log10((double)d);
        return (int)d2;
    }

    private void drawLinedGrid(Graphics2D graphics2D) {
        Object object;
        int n = this.viewport.gridMagnitudeModel();
        double d = Math.pow(10.0, n);
        double d2 = this.viewport.toView(d);
        Envelope envelope = this.viewport.getModelEnv();
        double d3 = 10.0 * d;
        PrecisionModel precisionModel = new PrecisionModel(1.0 / d3);
        double d4 = precisionModel.makePrecise(envelope.getMinX());
        double d5 = precisionModel.makePrecise(envelope.getMinY());
        Point2D point2D = this.viewport.toView(new Coordinate(d4, d5));
        double d6 = this.viewport.toView(d3);
        double d7 = 100.0 * d;
        PrecisionModel precisionModel2 = new PrecisionModel(1.0 / d7);
        double d8 = precisionModel2.makePrecise(envelope.getMinX());
        double d9 = precisionModel2.makePrecise(envelope.getMinY());
        Point2D point2D2 = this.viewport.toView(new Coordinate(d8, d9));
        double d10 = this.viewport.toView(d7);
        if (d2 >= 4.0) {
            object = new PrecisionModel(1.0 / d);
            double d11 = object.makePrecise(envelope.getMinX());
            double d12 = object.makePrecise(envelope.getMinY());
            Point2D point2D3 = this.viewport.toView(new Coordinate(d11, d12));
            graphics2D.setStroke(new BasicStroke());
            graphics2D.setColor(ColorUtil.gray(240));
            this.drawGridLines(graphics2D, point2D3.getX(), point2D3.getY(), d2);
        }
        graphics2D.setStroke(new BasicStroke());
        graphics2D.setColor(ColorUtil.gray(220));
        this.drawGridLines(graphics2D, point2D.getX(), point2D.getY(), d6);
        object = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{4.0f, 6.0f}, 0.0f);
        graphics2D.setStroke((Stroke)object);
        graphics2D.setColor(ColorUtil.gray(100));
        this.drawGridLines(graphics2D, point2D2.getX(), point2D2.getY(), d10);
        float f = (int)point2D.getY() % (int)d6;
        f = (float)(d6 - (double)f + d6 / 2.0);
        graphics2D.setColor(Color.BLACK);
        BasicStroke basicStroke = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{0.0f, (float)d6 / 2.0f}, f);
        graphics2D.setStroke(basicStroke);
        this.drawGridLines(graphics2D, point2D.getX() - d6 / 2.0, 0.0, d6 / 2.0);
    }

    private void drawDottedGrid(Graphics2D graphics2D) {
        Object object;
        int n = this.viewport.gridMagnitudeModel();
        double d = Math.pow(10.0, n);
        double d2 = this.viewport.toView(d);
        double d3 = 10.0 * d;
        PrecisionModel precisionModel = new PrecisionModel(1.0 / d3);
        Envelope envelope = this.viewport.getModelEnv();
        double d4 = precisionModel.makePrecise(envelope.getMinX());
        double d5 = precisionModel.makePrecise(envelope.getMinY());
        Point2D point2D = this.viewport.toView(new Coordinate(d4, d5));
        double d6 = this.viewport.toView(d3);
        graphics2D.setStroke(new BasicStroke());
        graphics2D.setColor(AppConstants.GRID_MAJOR_CLR);
        this.drawGridLines(graphics2D, point2D.getX(), point2D.getY(), d6);
        double d7 = 100.0 * d;
        PrecisionModel precisionModel2 = new PrecisionModel(1.0 / d7);
        double d8 = precisionModel2.makePrecise(envelope.getMinX());
        double d9 = precisionModel2.makePrecise(envelope.getMinY());
        Point2D point2D2 = this.viewport.toView(new Coordinate(d8, d9));
        double d10 = this.viewport.toView(d7);
        BasicStroke basicStroke = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{4.0f, 6.0f}, 0.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(AppConstants.GRID_MINOR_CLR);
        this.drawGridLines(graphics2D, point2D2.getX(), point2D2.getY(), d10);
        float f = (int)point2D.getY() % (int)d6;
        f = (float)(d6 - (double)f + d6 / 2.0);
        if (d2 >= 4.0) {
            object = new PrecisionModel(1.0 / d);
            double d11 = object.makePrecise(envelope.getMinX());
            double d12 = object.makePrecise(envelope.getMinY());
            Point2D point2D3 = this.viewport.toView(new Coordinate(d11, d12));
            float f2 = (int)point2D3.getY() % (int)d2;
            f2 = (float)d2 - f2;
            BasicStroke basicStroke2 = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{0.0f, (float)d2}, f2);
            graphics2D.setStroke(basicStroke2);
            graphics2D.setColor(AppConstants.GRID_MINOR_CLR);
            this.drawGridLines(graphics2D, point2D3.getX(), 0.0, d2);
        }
        graphics2D.setColor(Color.BLACK);
        object = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{0.0f, (float)d6 / 2.0f}, f);
        graphics2D.setStroke((Stroke)object);
        this.drawGridLines(graphics2D, point2D.getX() - d6 / 2.0, 0.0, d6 / 2.0);
    }

    private void drawGridSizeLabel(Graphics2D graphics2D, int n) {
        graphics2D.setColor(Color.BLUE);
        int n2 = (int)this.viewport.getHeightInView();
        int n3 = (int)this.viewport.getWidthInView();
        if (Math.abs(n) <= 3) {
            double d = Math.pow(10.0, n);
            graphics2D.drawString(this.gridSizeFormat.format(d), 2, n2 - 1);
        } else {
            graphics2D.drawString("10", 2, n2 - 1);
            graphics2D.drawString(n + "", 20, n2 - 8);
        }
    }

    private void drawFixedGrid(Graphics2D graphics2D) {
        double d = this.grid.getGridSize();
        double d2 = d * this.viewport.getScale();
        Point2D point2D = this.viewport.getLowerLeftCornerInModel();
        double d3 = this.grid.snapToMajorGrid(point2D).getX();
        double d4 = this.grid.snapToMajorGrid(point2D).getY();
        Point2D point2D2 = this.viewport.toView(new Coordinate(d3, d4));
        graphics2D.setColor(AppConstants.GRID_MAJOR_CLR);
        this.drawGridLines(graphics2D, point2D2.getX(), point2D2.getY(), d2);
    }

    private void drawGridLines(Graphics2D graphics2D, double d, double d2, double d3) {
        double d4;
        double d5 = this.viewport.getWidthInView();
        double d6 = this.viewport.getHeightInView();
        for (d4 = d; d4 < d5; d4 += d3) {
            if (d4 < 2.0) continue;
            graphics2D.draw(new Line2D.Double(d4, 0.0, d4, d6 - 0.0));
        }
        if (d2 <= 0.0) {
            return;
        }
        for (d4 = d2; d4 > 0.0; d4 -= d3) {
            if (d4 < 2.0) continue;
            graphics2D.draw(new Line2D.Double(0.0, d4, d5 - 0.0, d4));
        }
    }

    private void drawScaleMarks(Graphics2D graphics2D) {
        Envelope envelope = this.viewport.getViewEnv();
        int n = this.maxVisibleMagnitude();
        double d = Math.pow(10.0, n);
        double d2 = this.viewport.toView(d);
        if (3.0 * d2 > envelope.maxExtent()) {
            d2 /= 10.0;
            --n;
        }
        graphics2D.setColor(Color.BLACK);
        int n2 = (int)this.viewport.getHeightInView();
        for (double d3 = this.viewport.getWidthInView() - d2; d3 > 0.0; d3 -= d2) {
            graphics2D.draw(new Line2D.Double(d3, n2 + 1, d3, n2 - 5));
        }
        int n3 = (int)this.viewport.getWidthInView();
        for (double d4 = this.viewport.getHeightInView() - d2; d4 > 0.0; d4 -= d2) {
            graphics2D.draw(new Line2D.Double(n3 + 1, d4, n3 - 5, d4));
        }
        graphics2D.drawString("10", n3 - 35, n2 - 1);
        graphics2D.drawString(n + "", n3 - 20, n2 - 8);
    }
}

