/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.style;

import com.vividsolutions.jtstest.testbuilder.Viewport;
import com.vividsolutions.jtstest.testbuilder.ui.style.ArrowEndpointStyle;
import com.vividsolutions.jtstest.testbuilder.ui.style.SegmentStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;

public class ArrowLineStyle
extends SegmentStyle {
    private static final double HEAD_ANGLE = 30.0;
    private static final double HEAD_LENGTH = 6.0;
    private Color color = Color.RED;
    private static Stroke dashStroke = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);
    private static final double LINE_OFFSET = 4.0;
    private static final double ENDPOINT_OFFSET = 10.0;
    private static final double HEAD_ANGLE_RAD = -2.6179938779914944;
    private static final double HEAD_COS = Math.cos(-2.6179938779914944);
    private static final double HEAD_SIN = Math.sin(-2.6179938779914944);
    public static final double MIN_VISIBLE_LEN = 24.0;

    public ArrowLineStyle(Color color) {
        this.color = color;
    }

    protected void paint(Point2D point2D, Point2D point2D2, int n, Viewport viewport, Graphics2D graphics2D) throws Exception {
        if (n == 1) {
            this.paintMidpointArrow(point2D, point2D2, viewport, graphics2D);
        } else {
            this.paintOffsetArrow(point2D, point2D2, viewport, graphics2D);
        }
    }

    protected void paintMidpointArrow(Point2D point2D, Point2D point2D2, Viewport viewport, Graphics2D graphics2D) throws NoninvertibleTransformException {
        if (this.isTooSmallToRender(point2D, point2D2)) {
            return;
        }
        graphics2D.setColor(this.color);
        Point2D.Float float_ = new Point2D.Float((float)((point2D.getX() + point2D2.getX()) / 2.0), (float)((point2D.getY() + point2D2.getY()) / 2.0));
        GeneralPath generalPath = ArrowEndpointStyle.arrowheadPath(point2D, point2D2, float_, 6.0, 30.0);
        graphics2D.draw(generalPath);
    }

    protected void paintOffsetArrow(Point2D point2D, Point2D point2D2, Viewport viewport, Graphics2D graphics2D) throws NoninvertibleTransformException {
        if (this.isTooSmallToRender(point2D, point2D2)) {
            return;
        }
        graphics2D.setColor(this.color);
        graphics2D.setStroke(dashStroke);
        double d = point2D2.getX() - point2D.getX();
        double d2 = point2D2.getY() - point2D.getY();
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = d2 / d3;
        double d5 = d / d3;
        double d6 = point2D.getX() + 10.0 * d5 + 4.0 * d4;
        double d7 = point2D.getY() + 10.0 * d4 + 4.0 * -d5;
        double d8 = point2D2.getX() - 10.0 * d5 + 4.0 * d4;
        double d9 = point2D2.getY() - 10.0 * d4 + 4.0 * -d5;
        double d10 = d8 + 6.0 * (HEAD_COS * d5 - HEAD_SIN * d4);
        double d11 = d9 + 6.0 * (HEAD_SIN * d5 + HEAD_COS * d4);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)d6, (float)d7);
        generalPath.lineTo((float)d8, (float)d9);
        generalPath.lineTo((float)d10, (float)d11);
        graphics2D.draw(generalPath);
    }

    private boolean isTooSmallToRender(Point2D point2D, Point2D point2D2) {
        double d;
        if (point2D.equals(point2D2)) {
            return true;
        }
        double d2 = point2D2.getX() - point2D.getX();
        double d3 = Math.sqrt(d2 * d2 + (d = point2D2.getY() - point2D.getY()) * d);
        return d3 < 24.0;
    }
}

