/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.style;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.testbuilder.Viewport;
import com.vividsolutions.jtstest.testbuilder.ui.style.Style;
import com.vividsolutions.jtstest.testbuilder.ui.style.StyleEntry;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public class StyleList
implements Style {
    private List styleList = new ArrayList();

    public void paint(Geometry geometry, Viewport viewport, Graphics2D graphics2D) throws Exception {
        for (StyleEntry styleEntry : this.styleList) {
            if (!styleEntry.isFullyEnabled()) continue;
            styleEntry.getStyle().paint(geometry, viewport, graphics2D);
        }
    }

    public void add(Style style) {
        this.add(style, null);
    }

    public void add(Style style, StyleFilter styleFilter) {
        this.styleList.add(new StyleEntry(style, styleFilter));
    }

    public void setEnabled(Style style, boolean bl) {
        StyleEntry styleEntry = this.getEntry(style);
        if (styleEntry == null) {
            return;
        }
        styleEntry.setEnabled(bl);
    }

    private StyleEntry getEntry(Style style) {
        int n = this.getEntryIndex(style);
        if (n < 0) {
            return null;
        }
        return (StyleEntry)this.styleList.get(n);
    }

    private int getEntryIndex(Style style) {
        for (int i = 0; i < this.styleList.size(); ++i) {
            StyleEntry styleEntry = (StyleEntry)this.styleList.get(i);
            if (styleEntry.getStyle() != style) continue;
            return i;
        }
        return -1;
    }

    public static interface StyleFilter {
        public boolean isFiltered(Style var1);
    }
}

