/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.tools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jtstest.testbuilder.ui.tools.LineBandTool;
import java.awt.Cursor;
import java.awt.event.MouseEvent;

public abstract class AbstractStreamDrawTool
extends LineBandTool {
    private Cursor cursor = Cursor.getPredefinedCursor(1);

    protected AbstractStreamDrawTool() {
    }

    protected abstract int getGeometryType();

    protected void mouseLocationChanged(MouseEvent mouseEvent) {
        try {
            if ((mouseEvent.getModifiersEx() & 0x400) == 1024) {
                Coordinate coordinate = this.toModelCoordinate(mouseEvent.getPoint());
                if (coordinate.distance(this.lastCoordinate()) < this.gridSize()) {
                    return;
                }
                this.add(coordinate);
            }
            this.tentativeCoordinate = this.toModelSnapped(mouseEvent.getPoint());
            this.redrawIndicator();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.setBandType();
        super.mouseClicked(mouseEvent);
    }

    protected void bandFinished() throws Exception {
        this.setType();
        this.geomModel().addComponent(this.getCoordinates());
        this.panel().updateGeom();
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    private void setType() {
        if (this.panel().getModel() == null) {
            return;
        }
        this.panel().getGeomModel().setGeometryType(this.getGeometryType());
    }

    private void setBandType() {
        int n = this.getGeometryType();
        this.setCloseRing(n == 5);
    }
}

