/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.tools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jtstest.testbuilder.ui.tools.IndicatorTool;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public abstract class BoxBandTool
extends IndicatorTool {
    private Cursor cursor = Cursor.getDefaultCursor();
    private Point zoomBoxStart = null;
    private Point zoomBoxEnd = null;
    private static final int MIN_MOVEMENT = 3;

    public BoxBandTool() {
    }

    public BoxBandTool(Cursor cursor) {
        this();
        this.cursor = cursor;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.zoomBoxStart = mouseEvent.getPoint();
        this.zoomBoxEnd = null;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.clearIndicator();
        if (!this.isSignificantMouseMove()) {
            return;
        }
        this.gestureFinished();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        this.zoomBoxEnd = mouseEvent.getPoint();
        this.redrawIndicator();
    }

    protected Shape getShape() {
        if (this.zoomBoxEnd == null) {
            return null;
        }
        Envelope envelope = this.getEnvelope();
        Point2D point2D = this.toView(new Coordinate(envelope.getMinX(), envelope.getMaxY()));
        double d = this.toView(envelope.getWidth());
        double d2 = this.toView(envelope.getHeight());
        return new Rectangle2D.Double(point2D.getX(), point2D.getY(), d, d2);
    }

    private boolean isSignificantMouseMove() {
        if (this.zoomBoxEnd == null) {
            return false;
        }
        if (Math.abs(this.zoomBoxStart.x - this.zoomBoxEnd.x) < 3) {
            return false;
        }
        return Math.abs(this.zoomBoxStart.y - this.zoomBoxEnd.y) >= 3;
    }

    protected Envelope getEnvelope() {
        Coordinate coordinate = this.toModelSnapped(this.zoomBoxStart);
        Coordinate coordinate2 = this.toModelSnapped(this.zoomBoxEnd);
        return new Envelope(coordinate, coordinate2);
    }

    protected List getCoordinatesOfEnvelope() {
        Envelope envelope = this.getEnvelope();
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        arrayList.add(new Coordinate(envelope.getMinX(), envelope.getMinY()));
        arrayList.add(new Coordinate(envelope.getMinX(), envelope.getMaxY()));
        arrayList.add(new Coordinate(envelope.getMaxX(), envelope.getMaxY()));
        arrayList.add(new Coordinate(envelope.getMaxX(), envelope.getMinY()));
        arrayList.add(new Coordinate(envelope.getMinX(), envelope.getMinY()));
        return arrayList;
    }

    protected List getCoordinates() {
        Coordinate coordinate = this.toModelSnapped(this.zoomBoxStart);
        Coordinate coordinate2 = this.toModelSnapped(this.zoomBoxEnd);
        boolean bl = coordinate.x < coordinate2.x && coordinate.y < coordinate2.y || coordinate.x > coordinate2.x && coordinate.y > coordinate2.y;
        Coordinate coordinate3 = new Coordinate(coordinate.x, coordinate2.y);
        Coordinate coordinate4 = new Coordinate(coordinate2.x, coordinate.y);
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        arrayList.add(new Coordinate(coordinate));
        if (bl) {
            arrayList.add(coordinate3);
        } else {
            arrayList.add(coordinate4);
        }
        arrayList.add(new Coordinate(coordinate2));
        if (bl) {
            arrayList.add(coordinate4);
        } else {
            arrayList.add(coordinate3);
        }
        arrayList.add(new Coordinate(coordinate));
        return arrayList;
    }

    protected void gestureFinished() {
    }
}

