/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.tools;

import com.vividsolutions.jtstest.testbuilder.AppConstants;
import com.vividsolutions.jtstest.testbuilder.ui.tools.BasicTool;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;

public abstract class IndicatorTool
extends BasicTool {
    private Color bandColor = AppConstants.BAND_CLR;
    private Point mousePoint;
    private Shape lastShapeDrawn;
    private String lastLabelDrawn = null;
    private Point lastLabelLoc = null;
    private boolean isIndicatorVisible = false;
    private Color originalColor;
    private Stroke originalStroke;
    private Font originalFont;

    protected Shape getShape() {
        return null;
    }

    public boolean isIndicatorVisible() {
        return this.isIndicatorVisible;
    }

    private void setIndicatorVisible(boolean bl) {
        this.isIndicatorVisible = bl;
    }

    protected void clearIndicator() {
        this.clearShape(this.getGraphics2D());
    }

    protected void redrawIndicator() {
        try {
            this.redrawShape(this.getGraphics2D());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void clearShape(Graphics2D graphics2D) {
        if (!this.isIndicatorVisible) {
            return;
        }
        this.drawShapeXOR(graphics2D, this.lastShapeDrawn, this.lastLabelDrawn, this.lastLabelLoc);
        this.setIndicatorVisible(false);
    }

    private void redrawShape(Graphics2D graphics2D) throws Exception {
        this.clearShape(graphics2D);
        this.drawShapeXOR(graphics2D);
        this.setIndicatorVisible(true);
    }

    private void drawShapeXOR(Graphics2D graphics2D) throws Exception {
        Shape shape = this.getShape();
        String string = this.getLabel();
        this.drawShapeXOR(graphics2D, shape, string, this.mousePoint);
        this.lastShapeDrawn = shape;
        this.lastLabelDrawn = string;
        this.lastLabelLoc = this.mousePoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawShapeXOR(Graphics2D graphics2D, Shape shape, String string, Point point) {
        this.setup(graphics2D);
        try {
            if (shape != null) {
                graphics2D.draw(shape);
            }
        }
        finally {
            this.cleanup(graphics2D);
        }
    }

    private void setup(Graphics2D graphics2D) {
        this.originalColor = graphics2D.getColor();
        this.originalStroke = graphics2D.getStroke();
        this.originalFont = graphics2D.getFont();
        graphics2D.setFont(new Font("SanSerif", 0, 14));
        graphics2D.setColor(this.bandColor);
        graphics2D.setXORMode(Color.white);
    }

    private void cleanup(Graphics2D graphics2D) {
        graphics2D.setPaintMode();
        graphics2D.setColor(this.originalColor);
        graphics2D.setStroke(this.originalStroke);
        graphics2D.setFont(this.originalFont);
    }

    private void recordLabel(Point point) {
        this.mousePoint = new Point(point.x + 5, point.y);
    }

    private String getLabel() {
        if (this.mousePoint == null) {
            return null;
        }
        return this.mousePoint.x + "," + this.mousePoint.y;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.recordLabel(mouseEvent.getPoint());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.recordLabel(mouseEvent.getPoint());
    }
}

