/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testrunner;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jtstest.TestCoordinateSequenceFactory;
import com.vividsolutions.jtstest.geomop.GeometryOperation;
import com.vividsolutions.jtstest.testrunner.BooleanResult;
import com.vividsolutions.jtstest.testrunner.DoubleResult;
import com.vividsolutions.jtstest.testrunner.GeometryResult;
import com.vividsolutions.jtstest.testrunner.IntegerResult;
import com.vividsolutions.jtstest.testrunner.Result;
import com.vividsolutions.jtstest.testrunner.ResultMatcher;
import com.vividsolutions.jtstest.testrunner.Test;
import com.vividsolutions.jtstest.testrunner.TestCase;
import com.vividsolutions.jtstest.testrunner.TestParseException;
import com.vividsolutions.jtstest.testrunner.TestRun;
import com.vividsolutions.jtstest.testrunner.TopologyTestApp;
import com.vividsolutions.jtstest.util.FileUtil;
import com.vividsolutions.jtstest.util.LineNumberElement;
import com.vividsolutions.jtstest.util.LineNumberSAXBuilder;
import com.vividsolutions.jtstest.util.StringUtil;
import com.vividsolutions.jtstest.util.WKTOrWKBReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;

public class TestReader {
    private static final String TAG_geometryOperation = "geometryOperation";
    private static final String TAG_resultMatcher = "resultMatcher";
    Vector parsingProblems = new Vector();
    private GeometryFactory geometryFactory;
    private WKTOrWKBReader wktorbReader;
    private double tolerance = 0.0;
    private GeometryOperation geomOp = null;
    private ResultMatcher resultMatcher = null;

    public GeometryOperation getGeometryOperation() {
        if (TopologyTestApp.isGeometryOperationSpecified() || this.geomOp == null) {
            return TopologyTestApp.getGeometryOperation();
        }
        return this.geomOp;
    }

    public boolean isBooleanFunction(String string) {
        return this.getGeometryOperation().getReturnType(string) == Boolean.TYPE;
    }

    public boolean isIntegerFunction(String string) {
        return this.getGeometryOperation().getReturnType(string) == Integer.TYPE;
    }

    public boolean isDoubleFunction(String string) {
        return this.getGeometryOperation().getReturnType(string) == Double.TYPE;
    }

    public boolean isGeometryFunction(String string) {
        Class clazz = this.getGeometryOperation().getReturnType(string);
        if (clazz == null) {
            return false;
        }
        return Geometry.class.isAssignableFrom(clazz);
    }

    public List getParsingProblems() {
        return Collections.unmodifiableList(this.parsingProblems);
    }

    public void clearParsingProblems() {
        this.parsingProblems.clear();
    }

    public TestRun createTestRun(File file, int n) {
        try {
            LineNumberSAXBuilder lineNumberSAXBuilder = new LineNumberSAXBuilder();
            Document document = lineNumberSAXBuilder.build(new FileInputStream(file));
            Element element = document.getRootElement();
            if (!element.getName().equalsIgnoreCase("run")) {
                throw new TestParseException("Expected <run> but encountered <" + element.getName() + ">");
            }
            return this.parseTestRun(element, file, n);
        }
        catch (Exception exception) {
            this.parsingProblems.add("An exception occurred while parsing " + file + ": " + exception.toString());
            return null;
        }
    }

    private List parseTests(List list, int n, File file, TestCase testCase, double d) throws TestParseException {
        ArrayList<Test> arrayList = new ArrayList<Test>();
        int n2 = 0;
        for (Element element : list) {
            ++n2;
            try {
                String string;
                Element element2 = element.getChild("desc");
                if (element.getChildren("op").size() > 1) {
                    throw new TestParseException("Multiple <op>s in <test>");
                }
                Element element3 = element.getChild("op");
                if (element3 == null) {
                    throw new TestParseException("Missing <op> in <test>");
                }
                Attribute attribute = element3.getAttribute("name");
                if (attribute == null) {
                    throw new TestParseException("Missing name attribute in <op>");
                }
                String string2 = element3.getAttribute("arg1") == null ? "A" : element3.getAttribute("arg1").getValue().trim();
                String string3 = element3.getAttribute("arg2") == null ? null : element3.getAttribute("arg2").getValue().trim();
                String string4 = string = element3.getAttribute("arg3") == null ? null : element3.getAttribute("arg3").getValue().trim();
                if (string == null && attribute.getValue().trim().equalsIgnoreCase("relate")) {
                    string = element3.getAttribute("pattern") == null ? null : element3.getAttribute("pattern").getValue().trim();
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (string3 != null) {
                    arrayList2.add(string3);
                }
                if (string != null) {
                    arrayList2.add(string);
                }
                Result result = this.toResult(element3.getTextTrim(), attribute.getValue().trim(), testCase.getTestRun());
                Test test = new Test(testCase, n2, element2 != null ? element2.getTextTrim() : "", attribute.getValue().trim(), string2, arrayList2, result, d);
                arrayList.add(test);
            }
            catch (Exception exception) {
                this.parsingProblems.add("An exception occurred while parsing <test> " + n2 + " in <case> " + n + " in " + file + ": " + exception.toString() + "\n" + StringUtil.getStackTrace(exception));
            }
        }
        return arrayList;
    }

    private Result toResult(String string, String string2, TestRun testRun) throws TestParseException, ParseException {
        if (this.isBooleanFunction(string2)) {
            return this.toBooleanResult(string);
        }
        if (this.isIntegerFunction(string2)) {
            return this.toIntegerResult(string);
        }
        if (this.isDoubleFunction(string2)) {
            return this.toDoubleResult(string);
        }
        if (this.isGeometryFunction(string2)) {
            return this.toGeometryResult(string, testRun);
        }
        throw new TestParseException("Unknown operation name '" + string2 + "'");
    }

    private BooleanResult toBooleanResult(String string) throws TestParseException {
        if (string.equalsIgnoreCase("true")) {
            return new BooleanResult(true);
        }
        if (string.equalsIgnoreCase("false")) {
            return new BooleanResult(false);
        }
        throw new TestParseException("Expected 'true' or 'false' but encountered '" + string + "'");
    }

    private DoubleResult toDoubleResult(String string) throws TestParseException {
        try {
            return new DoubleResult(Double.valueOf(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new TestParseException("Expected double but encountered '" + string + "'");
        }
    }

    private IntegerResult toIntegerResult(String string) throws TestParseException {
        try {
            return new IntegerResult(Integer.valueOf(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new TestParseException("Expected integer but encountered '" + string + "'");
        }
    }

    private GeometryResult toGeometryResult(String string, TestRun testRun) throws ParseException {
        GeometryFactory geometryFactory = new GeometryFactory(testRun.getPrecisionModel(), 0);
        WKTOrWKBReader wKTOrWKBReader = new WKTOrWKBReader(geometryFactory);
        return new GeometryResult(wKTOrWKBReader.read(string));
    }

    private List parseTestCases(List list, File file, TestRun testRun, double d) throws TestParseException {
        this.geometryFactory = new GeometryFactory(testRun.getPrecisionModel(), 0, TestCoordinateSequenceFactory.instance());
        this.wktorbReader = new WKTOrWKBReader(this.geometryFactory);
        Vector<TestCase> vector = new Vector<TestCase>();
        int n = 0;
        for (Element element : list) {
            ++n;
            try {
                Element element2 = element.getChild("desc");
                Element element3 = element.getChild("a");
                Element element4 = element.getChild("b");
                File file2 = this.wktFile(element3, testRun);
                File file3 = this.wktFile(element4, testRun);
                Geometry geometry = this.readGeometry(element3, this.absoluteWktFile(file2, testRun));
                Geometry geometry2 = this.readGeometry(element4, this.absoluteWktFile(file3, testRun));
                TestCase testCase = new TestCase(element2 != null ? element2.getTextTrim() : "", geometry, geometry2, file2, file3, testRun, n, ((LineNumberElement)element).getStartLine());
                List list2 = element.getChildren("test");
                List list3 = this.parseTests(list2, n, file, testCase, d);
                for (Test test : list3) {
                    testCase.add(test);
                }
                vector.add(testCase);
            }
            catch (Exception exception) {
                this.parsingProblems.add("An exception occurred while parsing <case> " + n + " in " + file + ": " + exception.toString());
            }
        }
        return vector;
    }

    private TestRun parseTestRun(Element element, File file, int n) throws TestParseException {
        File file2 = null;
        if (element.getChild("workspace") != null) {
            if (element.getChild("workspace").getAttribute("dir") == null) {
                throw new TestParseException("Missing <dir> in <workspace>");
            }
            file2 = new File(element.getChild("workspace").getAttribute("dir").getValue().trim());
            if (!file2.exists()) {
                throw new TestParseException("<workspace> does not exist: " + file2);
            }
            if (!file2.isDirectory()) {
                throw new TestParseException("<workspace> is not a directory: " + file2);
            }
        }
        this.tolerance = this.parseTolerance(element);
        Element element2 = element.getChild("desc");
        this.geomOp = this.parseGeometryOperation(element);
        this.resultMatcher = this.parseResultMatcher(element);
        PrecisionModel precisionModel = this.parsePrecisionModel(element);
        TestRun testRun = new TestRun(element2 != null ? element2.getTextTrim() : "", n, precisionModel, this.geomOp, this.resultMatcher, file);
        testRun.setWorkspace(file2);
        List list = element.getChildren("case");
        if (list.size() == 0) {
            throw new TestParseException("Missing <case> in <run>");
        }
        for (TestCase testCase : this.parseTestCases(list, file, testRun, this.tolerance)) {
            testRun.addTestCase(testCase);
        }
        return testRun;
    }

    private PrecisionModel parsePrecisionModel(Element element) throws TestParseException {
        PrecisionModel precisionModel = new PrecisionModel();
        Element element2 = element.getChild("precisionModel");
        if (element2 == null) {
            return precisionModel;
        }
        Attribute attribute = element2.getAttribute("type");
        Attribute attribute2 = element2.getAttribute("scale");
        if (attribute == null && attribute2 == null) {
            throw new TestParseException("Missing type attribute in <precisionModel>");
        }
        if (attribute2 != null || attribute != null && attribute.getValue().trim().equalsIgnoreCase("FIXED")) {
            if (attribute != null && attribute.getValue().trim().equalsIgnoreCase("FLOATING")) {
                throw new TestParseException("scale attribute not allowed in floating <precisionModel>");
            }
            precisionModel = this.createPrecisionModel(element2);
        }
        return precisionModel;
    }

    private PrecisionModel createPrecisionModel(Element element) throws TestParseException {
        double d;
        Attribute attribute = element.getAttribute("scale");
        if (attribute == null) {
            throw new TestParseException("Missing scale attribute in <precisionModel>");
        }
        try {
            d = attribute.getDoubleValue();
        }
        catch (DataConversionException dataConversionException) {
            throw new TestParseException("Could not convert scale attribute to double: " + attribute.getValue());
        }
        return new PrecisionModel(d);
    }

    private GeometryOperation parseGeometryOperation(Element element) throws TestParseException {
        Element element2 = element.getChild(TAG_geometryOperation);
        if (element2 == null) {
            return null;
        }
        String string = element2.getTextTrim();
        GeometryOperation geometryOperation = (GeometryOperation)this.getInstance(string, GeometryOperation.class);
        if (geometryOperation == null) {
            throw new TestParseException("Could not create instance of GeometryOperation from class " + string);
        }
        return geometryOperation;
    }

    private ResultMatcher parseResultMatcher(Element element) throws TestParseException {
        Element element2 = element.getChild(TAG_resultMatcher);
        if (element2 == null) {
            return null;
        }
        String string = element2.getTextTrim();
        ResultMatcher resultMatcher = (ResultMatcher)this.getInstance(string, ResultMatcher.class);
        if (resultMatcher == null) {
            throw new TestParseException("Could not create instance of ResultMatcher from class " + string);
        }
        return resultMatcher;
    }

    private double parseTolerance(Element element) throws TestParseException {
        double d = 0.0;
        Element element2 = element.getChild("tolerance");
        if (element2 != null) {
            try {
                d = Double.parseDouble(element2.getTextTrim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new TestParseException("Could not parse tolerance from string: " + element2.getTextTrim());
            }
        }
        return d;
    }

    private Object getInstance(String string, Class clazz) {
        Object var3_3 = null;
        try {
            Class<?> clazz2 = Class.forName(string);
            if (!clazz.isAssignableFrom(clazz2)) {
                return null;
            }
            var3_3 = clazz2.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
        return var3_3;
    }

    private File wktFile(Element element, TestRun testRun) throws TestParseException {
        if (element == null) {
            return null;
        }
        if (element.getAttribute("file") == null) {
            return null;
        }
        if (!element.getTextTrim().equals("")) {
            throw new TestParseException("WKT specified both in-line and in external file");
        }
        File file = new File(element.getAttribute("file").getValue().trim());
        File file2 = this.absoluteWktFile(file, testRun);
        if (!file2.exists()) {
            throw new TestParseException("WKT file does not exist: " + file2);
        }
        if (file2.isDirectory()) {
            throw new TestParseException("WKT file is a directory: " + file2);
        }
        return file;
    }

    private Geometry readGeometry(Element element, File file) throws FileNotFoundException, ParseException, IOException {
        String string = null;
        if (file != null) {
            List list = FileUtil.getContents(file.getPath());
            string = this.toString(list);
        } else {
            if (element == null) {
                return null;
            }
            string = element.getTextTrim();
        }
        return this.wktorbReader.read(string);
    }

    private String toString(List list) {
        String string = "";
        for (String string2 : list) {
            string = string + string2 + "\n";
        }
        return string;
    }

    private File absoluteWktFile(File file, TestRun testRun) {
        if (file == null) {
            return null;
        }
        File file2 = file;
        if (!file2.isAbsolute()) {
            File file3 = testRun.getWorkspace() != null ? testRun.getWorkspace() : testRun.getTestFile().getParentFile();
            file2 = new File(file3 + File.separator + file2.getName());
        }
        return file2;
    }
}

