/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testrunner;

import com.vividsolutions.jts.JTSVersion;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jtstest.command.CommandLine;
import com.vividsolutions.jtstest.command.Option;
import com.vividsolutions.jtstest.command.OptionSpec;
import com.vividsolutions.jtstest.command.ParseException;
import com.vividsolutions.jtstest.function.GeometryFunctionRegistry;
import com.vividsolutions.jtstest.function.TestCaseGeometryFunctions;
import com.vividsolutions.jtstest.geomop.GeometryFunctionOperation;
import com.vividsolutions.jtstest.geomop.GeometryOperation;
import com.vividsolutions.jtstest.testrunner.EqualityResultMatcher;
import com.vividsolutions.jtstest.testrunner.GeometryOperationLoader;
import com.vividsolutions.jtstest.testrunner.GuiUtil;
import com.vividsolutions.jtstest.testrunner.ResultMatcher;
import com.vividsolutions.jtstest.testrunner.SimpleReportWriter;
import com.vividsolutions.jtstest.testrunner.TestEngine;
import com.vividsolutions.jtstest.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TopologyTestApp
extends JFrame {
    private static final String OPT_GEOMFUNC = "geomfunc";
    private static final String OPT_GEOMOP = "geomop";
    private static final String OPT_TESTCASEINDEX = "testCaseIndex";
    private static final String OPT_VERBOSE = "verbose";
    private static CommandLine commandLine;
    private static GeometryFunctionRegistry funcRegistry;
    private static GeometryOperation defaultOp;
    private static GeometryOperation geometryOp;
    private static ResultMatcher defaultResultMatcher;
    private static ResultMatcher resultMatcher;
    private TestEngine engine = new TestEngine();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel jPanel5 = new JPanel();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    JScrollPane jScrollPane2 = new JScrollPane();
    JTextArea logTextArea = new JTextArea();
    JPanel jPanel3 = new JPanel();
    JLabel statusLabel = new JLabel();
    BorderLayout borderLayout1 = new BorderLayout();
    JList fileList;
    JScrollPane jScrollPane1 = new JScrollPane();
    JButton runSelectedButton = new JButton();
    JButton addFileButton = new JButton();
    JPanel jPanel2 = new JPanel();
    FlowLayout flowLayout2 = new FlowLayout();
    JButton runAllButton = new JButton();
    JButton removeFileButton = new JButton();
    private DefaultListModel fileListModel = new DefaultListModel();
    private JFileChooser chooser = new JFileChooser();
    private Timer timer = new Timer(2000, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            TopologyTestApp.this.updateEnabled();
            if (!TopologyTestApp.this.engine.isRunning()) {
                TopologyTestApp.this.timer.stop();
                TopologyTestApp.this.logTextArea.setText(TopologyTestApp.this.report() + "\n\n" + TopologyTestApp.this.summary());
                TopologyTestApp.this.statusLabel.setText(TopologyTestApp.this.oneLineSummary());
            }
        }
    });

    public static GeometryOperation getGeometryOperation() {
        return geometryOp;
    }

    public static boolean isGeometryOperationSpecified() {
        return geometryOp != defaultOp;
    }

    public static ResultMatcher getResultMatcher() {
        return resultMatcher;
    }

    public static boolean isResultMatcherSpecified() {
        return resultMatcher != defaultResultMatcher;
    }

    public TopologyTestApp(List list) {
        this();
        try {
            this.add(list);
        }
        catch (Exception exception) {
            this.reportException(exception);
        }
    }

    public TopologyTestApp() {
        try {
            this.jbInit();
            this.chooser.setDialogTitle("Select topology test files");
            this.chooser.setDialogType(0);
            this.chooser.setFileSelectionMode(0);
            this.chooser.setMultiSelectionEnabled(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            TopologyTestApp.parseCommandLine(stringArray);
            System.out.println("=====  Test Runner  -  JTS Topology Suite (Version " + JTSVersion.CURRENT_VERSION + ")  =====");
            TopologyTestApp topologyTestApp = new TopologyTestApp(TopologyTestApp.testFiles());
            if (stringArray.length == 0) {
                TopologyTestApp.displayHelp();
                System.exit(0);
            }
            if (commandLine.hasOption(OPT_GEOMOP)) {
                string = commandLine.getOption(OPT_GEOMOP).getArg(0);
                geometryOp = GeometryOperationLoader.createGeometryOperation(TopologyTestApp.class.getClassLoader(), string);
                if (geometryOp == null) {
                    System.exit(0);
                }
                System.out.println("Using Geometry Operation: " + string);
            }
            if (commandLine.hasOption(OPT_GEOMFUNC)) {
                string = commandLine.getOption(OPT_GEOMFUNC).getArg(0);
                System.out.println("Adding Geometry Functions from: " + string);
                funcRegistry.add(string);
            }
            if (commandLine.hasOption(OPT_TESTCASEINDEX)) {
                int n = commandLine.getOption(OPT_TESTCASEINDEX).getArgAsInt(0);
                topologyTestApp.engine.setTestCaseIndexToRun(n);
                System.out.println("Running test case # " + n);
            }
            if (!commandLine.hasOption("GUI")) {
                topologyTestApp.engine.setTestFiles(topologyTestApp.getAllTestFiles());
                topologyTestApp.engine.run();
                System.out.println(topologyTestApp.report());
                System.exit(0);
            } else {
                topologyTestApp.setVisible(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }

    private static void parseCommandLine(String[] stringArray) throws ParseException {
        commandLine = new CommandLine('-');
        OptionSpec optionSpec = new OptionSpec("files", -2);
        commandLine.addOptionSpec(optionSpec);
        optionSpec = new OptionSpec("properties", 1);
        commandLine.addOptionSpec(optionSpec);
        commandLine.addOptionSpec(new OptionSpec(OPT_GEOMOP, 1));
        commandLine.addOptionSpec(new OptionSpec(OPT_GEOMFUNC, 1));
        optionSpec = new OptionSpec("gui", 0);
        commandLine.addOptionSpec(optionSpec);
        commandLine.addOptionSpec(new OptionSpec(OPT_TESTCASEINDEX, 1));
        commandLine.addOptionSpec(new OptionSpec(OPT_VERBOSE, 0));
        commandLine.parse(stringArray);
    }

    private static void displayHelp() {
        System.out.println("");
        System.out.println("Usage: java com.vividsolutions.jtstest.testrunner.TopologyTestApp ");
        System.out.println("           [-files <.xml files>] [-gui] ");
        System.out.println("           [-geomfunc <classname>]");
        System.out.println("           [-geomop <GeometryOperation classname>]");
        System.out.println("           [-testIndex <number>]");
        System.out.println("           [-verbose]");
        System.out.println("           [-properties <file.properties>]");
        System.out.println("");
        System.out.println("  -files          run a list of .xml files or directories");
        System.out.println("                  containing .xml files");
        System.out.println("  -properties     load/save .xml filenames in a .properties file");
        System.out.println("  -geomfunc         specifies the class providing the geometry operations");
        System.out.println("  -geomop         specifies the class providing the geometry operations");
        System.out.println("  -gui            use the graphical user interface");
        System.out.println("  -testIndex      specfies the index of a single test to run");
        System.out.println("  -verbose        display the results of successful tests");
    }

    private static Collection filenames(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : collection) {
            File file = new File(string);
            if (file.isDirectory()) {
                arrayList.addAll(TopologyTestApp.filenames(file));
                continue;
            }
            if (!file.isFile()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private static Collection filenames(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Assert.isTrue((boolean)file.isDirectory());
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isFile()) continue;
            arrayList.add(fileArray[i].getPath());
        }
        return arrayList;
    }

    private static Collection filenamesDeep(File file) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Assert.isTrue((boolean)file.isDirectory());
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile()) {
                arrayList.add(fileArray[i].getPath());
                continue;
            }
            if (!fileArray[i].isDirectory()) continue;
            arrayList.add(TopologyTestApp.filenamesDeep(fileArray[i]));
        }
        return arrayList;
    }

    private static List arguments(String string) {
        Option option = commandLine.getOption(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < option.getNumArgs(); ++i) {
            arrayList.add(option.getArg(i));
        }
        return arrayList;
    }

    private static List testFiles() throws FileNotFoundException, IOException {
        ArrayList arrayList = new ArrayList();
        if (commandLine.hasOption("Files")) {
            arrayList.addAll(TopologyTestApp.filenames(TopologyTestApp.arguments("Files")));
        }
        if (commandLine.hasOption("Properties")) {
            Properties properties = new Properties();
            File file = new File(commandLine.getOption("Properties").getArg(0));
            if (!file.exists()) {
                file.createNewFile();
            }
            properties.load(new FileInputStream(commandLine.getOption("Properties").getArg(0)));
            String string = properties.getProperty("TestFiles");
            if (string != null) {
                arrayList.addAll(StringUtil.fromCommaDelimitedString(string));
            }
        }
        return arrayList;
    }

    public void add(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            File file = new File(iterator.next().toString());
            this.fileListModel.addElement(file);
        }
    }

    public String summary() {
        String string = "";
        if (this.engine.getParseExceptionCount() > 0) {
            string = string + this.engine.getParseExceptionCount() + " parsing exceptions\n";
        }
        string = string + this.engine.getTestCaseCount() + " cases, " + this.engine.getTestCount() + " tests\n";
        string = string + this.engine.getPassedCount() + " passed, " + this.engine.getFailedCount() + " failed, " + this.engine.getExceptionCount() + " threw exceptions";
        if (this.engine.getParseExceptionCount() + this.engine.getFailedCount() + this.engine.getExceptionCount() > 0) {
            string = string + "*******  ERRORS ENCOUNTERED  ********";
        }
        return string;
    }

    public String oneLineSummary() {
        return StringUtil.replaceAll(this.summary(), "\n", "; ");
    }

    void this_windowClosing(WindowEvent windowEvent) {
        try {
            this.saveProperties();
        }
        catch (Exception exception) {
            this.reportException(exception);
        }
        System.exit(0);
    }

    void this_windowOpened(WindowEvent windowEvent) {
        GuiUtil.centerOnScreen(this);
    }

    void addFileButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (0 == this.chooser.showOpenDialog(this)) {
                File[] fileArray = this.chooser.getSelectedFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this.fileListModel.addElement(fileArray[i]);
                }
            }
            this.saveProperties();
        }
        catch (Exception exception) {
            this.reportException(exception);
        }
    }

    void removeFileButton_actionPerformed(ActionEvent actionEvent) {
        try {
            Iterator iterator = this.getSelectedTestFiles().iterator();
            while (iterator.hasNext()) {
                this.fileListModel.removeElement(iterator.next());
            }
            this.saveProperties();
            this.updateEnabled();
        }
        catch (Exception exception) {
            this.reportException(exception);
        }
    }

    void runSelectedButton_actionPerformed(ActionEvent actionEvent) {
        this.run(this.getSelectedTestFiles());
    }

    void runAllButton_actionPerformed(ActionEvent actionEvent) {
        this.updateEnabled();
        this.logTextArea.setText("");
        this.run(this.getAllTestFiles());
    }

    void fileList_valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    private List getSelectedTestFiles() {
        return Arrays.asList(this.fileList.getSelectedValues());
    }

    private List getAllTestFiles() {
        return Arrays.asList(this.fileListModel.toArray());
    }

    private void reportException(Exception exception) {
        exception.printStackTrace(System.out);
        JOptionPane.showMessageDialog(this, StringUtil.getStackTrace(exception), "Exception", 0);
    }

    private void jbInit() throws Exception {
        this.fileList = new JList(this.fileListModel);
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.setSize(450, 500);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TopologyTestApp.this.this_windowClosing(windowEvent);
            }

            public void windowOpened(WindowEvent windowEvent) {
                TopologyTestApp.this.this_windowOpened(windowEvent);
            }
        });
        this.jPanel5.setLayout(this.gridBagLayout4);
        this.setTitle("Topology Test App");
        this.jPanel3.setLayout(this.borderLayout1);
        this.statusLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusLabel.setText(" ");
        this.fileList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TopologyTestApp.this.updateEnabled();
            }
        });
        this.fileList.setBackground(SystemColor.control);
        this.fileList.setForeground(SystemColor.controlText);
        this.jScrollPane1.setMaximumSize(new Dimension(Short.MAX_VALUE, 100));
        this.jScrollPane1.setMinimumSize(new Dimension(24, 100));
        this.jScrollPane1.setPreferredSize(new Dimension(260, 100));
        this.runSelectedButton.setEnabled(false);
        this.runSelectedButton.setText("Run Selected");
        this.runSelectedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopologyTestApp.this.runSelectedButton_actionPerformed(actionEvent);
            }
        });
        this.addFileButton.setText("Add...");
        this.addFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopologyTestApp.this.addFileButton_actionPerformed(actionEvent);
            }
        });
        this.jPanel2.setLayout(this.flowLayout2);
        this.runAllButton.setText("Run All");
        this.runAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopologyTestApp.this.runAllButton_actionPerformed(actionEvent);
            }
        });
        this.removeFileButton.setEnabled(false);
        this.removeFileButton.setText("Remove Selected");
        this.removeFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopologyTestApp.this.removeFileButton_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add((Component)this.jPanel5, new GridBagConstraints(50, 83, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel5.add((Component)this.jScrollPane2, new GridBagConstraints(50, 60, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.getContentPane().add((Component)this.jPanel3, new GridBagConstraints(50, 102, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.statusLabel, "Center");
        this.getContentPane().add((Component)this.jScrollPane1, new GridBagConstraints(50, 45, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.getContentPane().add((Component)this.jPanel2, new GridBagConstraints(50, 54, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.addFileButton, null);
        this.jPanel2.add((Component)this.removeFileButton, null);
        this.jPanel2.add((Component)this.runSelectedButton, null);
        this.jPanel2.add((Component)this.runAllButton, null);
        this.jScrollPane1.getViewport().add((Component)this.fileList, null);
        this.jScrollPane2.getViewport().add((Component)this.logTextArea, null);
    }

    private void saveProperties() throws FileNotFoundException, IOException {
        if (!commandLine.hasOption("Properties")) {
            return;
        }
        List list = this.getAllTestFiles();
        String string = list.isEmpty() ? "" : StringUtil.toCommaDelimitedString(list);
        Properties properties = new Properties();
        properties.setProperty("TestFiles", string);
        properties.store(new FileOutputStream(commandLine.getOption("Properties").getArg(0)), "Properties file for " + this.getClass());
    }

    private void run(List list) {
        this.engine.setTestFiles(list);
        Thread thread = new Thread(this.engine);
        thread.start();
        this.timer.start();
        this.updateEnabled();
    }

    private void updateEnabled() {
        this.removeFileButton.setEnabled(!this.engine.isRunning() && this.fileList.getSelectedIndices().length > 0);
        this.runSelectedButton.setEnabled(!this.engine.isRunning() && this.fileList.getSelectedIndices().length > 0);
        this.runAllButton.setEnabled(!this.engine.isRunning());
        this.addFileButton.setEnabled(!this.engine.isRunning());
    }

    private String report() {
        SimpleReportWriter simpleReportWriter = new SimpleReportWriter(commandLine.hasOption("Verbose"));
        return simpleReportWriter.writeReport(this.engine);
    }

    static {
        funcRegistry = new GeometryFunctionRegistry(TestCaseGeometryFunctions.class);
        geometryOp = defaultOp = new GeometryFunctionOperation(funcRegistry);
        resultMatcher = defaultResultMatcher = new EqualityResultMatcher();
    }
}

