/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io.sde;

import com.esri.sde.sdk.client.SDEPoint;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeShape;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.ArrayList;

public class SdeReader {
    private GeometryFactory geometryFactory;
    private PrecisionModel precisionModel;
    private CoordinateSequenceFactory coordSeqFact;
    private int maxDimensionToRead = 2;

    public SdeReader() {
        this(new GeometryFactory());
    }

    public SdeReader(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
        this.precisionModel = geometryFactory.getPrecisionModel();
        this.coordSeqFact = geometryFactory.getCoordinateSequenceFactory();
    }

    public int getDimension() {
        return this.maxDimensionToRead;
    }

    public void setDimension(int n) {
        this.maxDimensionToRead = n;
    }

    public Geometry read(SeShape seShape) throws SeException {
        switch (seShape.getType()) {
            case 1: {
                return this.readPoint(seShape);
            }
            case 257: {
                return this.readMultiPoint(seShape);
            }
            case 2: 
            case 4: {
                return this.readLine(seShape);
            }
            case 258: 
            case 260: {
                return this.readMultiLine(seShape);
            }
            case 8: {
                return this.readPolygon(seShape);
            }
            case 264: {
                return this.readMultiPolygon(seShape);
            }
        }
        throw new IllegalArgumentException("Shapes of type " + seShape.getType() + " are not supported");
    }

    private Point readPoint(SeShape seShape) throws SeException {
        ArrayList arrayList = seShape.getAllPoints(2, false);
        SDEPoint[] sDEPointArray = (SDEPoint[])arrayList.get(0);
        return this.geometryFactory.createPoint(this.toCoordinates(sDEPointArray, 0, 1));
    }

    private MultiPoint readMultiPoint(SeShape seShape) throws SeException {
        ArrayList arrayList = seShape.getAllPoints(2, false);
        SDEPoint[] sDEPointArray = (SDEPoint[])arrayList.get(0);
        return this.geometryFactory.createMultiPoint(this.toCoordinates(sDEPointArray, 0, sDEPointArray.length));
    }

    private LineString readLine(SeShape seShape) throws SeException {
        ArrayList arrayList = seShape.getAllPoints(2, false);
        SDEPoint[] sDEPointArray = (SDEPoint[])arrayList.get(0);
        return this.geometryFactory.createLineString(this.toCoordinates(sDEPointArray, 0, sDEPointArray.length));
    }

    private MultiLineString readMultiLine(SeShape seShape) throws SeException {
        ArrayList arrayList = seShape.getAllPoints(2, false);
        SDEPoint[] sDEPointArray = (SDEPoint[])arrayList.get(0);
        int[] nArray = (int[])arrayList.get(1);
        LineString[] lineStringArray = new LineString[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n = sDEPointArray.length;
            if (i < nArray.length - 1) {
                n = nArray[i + 1];
            }
            lineStringArray[i] = this.geometryFactory.createLineString(this.toCoordinates(sDEPointArray, nArray[i], n));
        }
        return this.geometryFactory.createMultiLineString(lineStringArray);
    }

    private Polygon readPolygon(SeShape seShape) throws SeException {
        ArrayList arrayList = seShape.getAllPoints(2, true);
        SDEPoint[] sDEPointArray = (SDEPoint[])arrayList.get(0);
        int[] nArray = (int[])arrayList.get(2);
        return this.readPolygon(sDEPointArray, nArray, 0, nArray.length);
    }

    private Polygon readPolygon(SDEPoint[] sDEPointArray, int[] nArray, int n, int n2) throws SeException {
        int n3 = n2 - n;
        int n4 = n3 - 1;
        if (n4 < 0) {
            n4 = 0;
        }
        LinearRing linearRing = null;
        LinearRing[] linearRingArray = new LinearRing[n4];
        int n5 = 0;
        for (int i = n; i < n2; ++i) {
            int n6 = sDEPointArray.length;
            if (i < n2 - 1) {
                n6 = nArray[i + 1];
            }
            LinearRing linearRing2 = this.geometryFactory.createLinearRing(this.toCoordinates(sDEPointArray, nArray[i], n6));
            if (linearRing == null) {
                linearRing = linearRing2;
                continue;
            }
            linearRingArray[n5++] = linearRing2;
        }
        return this.geometryFactory.createPolygon(linearRing, linearRingArray);
    }

    private MultiPolygon readMultiPolygon(SeShape seShape) throws SeException {
        ArrayList arrayList = seShape.getAllPoints(2, true);
        SDEPoint[] sDEPointArray = (SDEPoint[])arrayList.get(0);
        int[] nArray = (int[])arrayList.get(1);
        int[] nArray2 = (int[])arrayList.get(2);
        Polygon[] polygonArray = new Polygon[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray2.length;
            if (i + 1 < nArray.length) {
                n = nArray[i + 1];
            }
            polygonArray[i] = this.readPolygon(sDEPointArray, nArray2, nArray[i], n);
        }
        return this.geometryFactory.createMultiPolygon(polygonArray);
    }

    private void readCoordinate(SDEPoint sDEPoint, CoordinateSequence coordinateSequence, int n) throws SeException {
        coordinateSequence.setOrdinate(n, 0, this.precisionModel.makePrecise(sDEPoint.getX()));
        coordinateSequence.setOrdinate(n, 1, this.precisionModel.makePrecise(sDEPoint.getY()));
        if (this.maxDimensionToRead >= 3 && sDEPoint.is3D()) {
            coordinateSequence.setOrdinate(n, 2, sDEPoint.getZ());
        }
    }

    private CoordinateSequence toCoordinates(SDEPoint[] sDEPointArray, int n, int n2) throws SeException {
        int n3 = n2 - n;
        CoordinateSequence coordinateSequence = this.coordSeqFact.create(n3, this.maxDimensionToRead);
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            this.readCoordinate(sDEPointArray[i], coordinateSequence, n4);
            ++n4;
        }
        return coordinateSequence;
    }
}

