/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtsexample.linearref;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.linearref.LengthIndexedLine;

public class LinearRefExample {
    static GeometryFactory fact = new GeometryFactory();
    static WKTReader rdr = new WKTReader(fact);

    public static void main(String[] stringArray) throws Exception {
        LinearRefExample linearRefExample = new LinearRefExample();
        linearRefExample.run();
    }

    public void run() throws Exception {
        this.runExtractedLine("LINESTRING (0 0, 10 10, 20 20)", 1.0, 10.0);
        this.runExtractedLine("MULTILINESTRING ((0 0, 10 10), (20 20, 25 25, 30 40))", 1.0, 20.0);
    }

    public void runExtractedLine(String string, double d, double d2) throws ParseException {
        System.out.println("=========================");
        Geometry geometry = rdr.read(string);
        System.out.println("Input Geometry: " + geometry);
        System.out.println("Indices to extract: " + d + " " + d2);
        LengthIndexedLine lengthIndexedLine = new LengthIndexedLine(geometry);
        Geometry geometry2 = lengthIndexedLine.extractLine(d, d2);
        System.out.println("Extracted Line: " + geometry2);
        double[] dArray = lengthIndexedLine.indicesOf(geometry2);
        System.out.println("Indices of extracted line: " + dArray[0] + " " + dArray[1]);
        Coordinate coordinate = lengthIndexedLine.extractPoint((dArray[0] + dArray[1]) / 2.0);
        System.out.println("Midpoint of extracted line: " + coordinate);
    }
}

