/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtsexample.technique;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.util.Stopwatch;
import com.vividsolutions.jtsexample.technique.PreparedGeometryIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchUsingPreparedGeometryIndex {
    static GeometryFactory geomFact = new GeometryFactory();
    static final int MAX_ITER = 200000;
    static final int GRID_SIZE = 10;
    static final int POLYGON_SIZE = 100;

    public static void main(String[] stringArray) throws Exception {
        List list = SearchUsingPreparedGeometryIndex.createCircleGrid(10);
        PreparedGeometryIndex preparedGeometryIndex = new PreparedGeometryIndex();
        preparedGeometryIndex.insert(list);
        Stopwatch stopwatch = new Stopwatch();
        int n = SearchUsingPreparedGeometryIndex.runIndexedQuery(preparedGeometryIndex);
        String string = stopwatch.getTimeString();
        System.out.println("Number of iterations       = 200000");
        System.out.println("Number of circles in grid  = " + list.size());
        System.out.println();
        System.out.println("The fraction of intersecting points should approximate the total area of the circles:");
        System.out.println();
        System.out.println("Area of circles                = " + SearchUsingPreparedGeometryIndex.area(list));
        System.out.println("Fraction of points in circles  = " + (double)n / 200000.0);
        System.out.println();
        System.out.println("Indexed Execution time: " + string);
        Stopwatch stopwatch2 = new Stopwatch();
        int n2 = SearchUsingPreparedGeometryIndex.runBruteForceQuery(list);
        String string2 = stopwatch2.getTimeString();
        System.out.println();
        System.out.println("Execution time: " + string2);
    }

    static int runIndexedQuery(PreparedGeometryIndex preparedGeometryIndex) {
        int n = 0;
        for (int i = 0; i < 200000; ++i) {
            Point point = SearchUsingPreparedGeometryIndex.createRandomPoint();
            if (preparedGeometryIndex.intersects((Geometry)point).size() <= 0) continue;
            ++n;
        }
        return n;
    }

    static int runBruteForceQuery(Collection collection) {
        int n = 0;
        for (int i = 0; i < 200000; ++i) {
            Point point = SearchUsingPreparedGeometryIndex.createRandomPoint();
            if (SearchUsingPreparedGeometryIndex.findIntersecting(collection, (Geometry)point).size() <= 0) continue;
            ++n;
        }
        return n;
    }

    static double area(Collection collection) {
        double d = 0.0;
        for (Geometry geometry : collection) {
            d += geometry.getArea();
        }
        return d;
    }

    static List createCircleGrid(int n) {
        double d = 1.0 / (double)n;
        double d2 = d / 2.0;
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                Coordinate coordinate = new Coordinate(d2 + (double)i * d, d2 + (double)j * d);
                Geometry geometry = SearchUsingPreparedGeometryIndex.createCircle(coordinate, d2);
                arrayList.add(geometry);
            }
        }
        return arrayList;
    }

    static Geometry createCircle(Coordinate coordinate, double d) {
        Point point = geomFact.createPoint(coordinate);
        return point.buffer(d, 100);
    }

    static Point createRandomPoint() {
        return geomFact.createPoint(new Coordinate(Math.random(), Math.random()));
    }

    static List findIntersecting(Collection collection, Geometry geometry) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (Geometry geometry2 : collection) {
            if (!geometry2.intersects(geometry)) continue;
            arrayList.add(geometry2);
        }
        return arrayList;
    }
}

