/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.clean;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;

public class CleanDuplicatePoints {
    private GeometryFactory fact;

    public static Coordinate[] removeDuplicatePoints(Coordinate[] coordinateArray) {
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        Coordinate coordinate = null;
        for (int i = 0; i < coordinateArray.length; ++i) {
            if (coordinate != null && coordinate.equals((Object)coordinateArray[i])) continue;
            coordinate = coordinateArray[i];
            arrayList.add(new Coordinate(coordinate));
        }
        return arrayList.toArray(new Coordinate[0]);
    }

    public Geometry clean(Geometry geometry) {
        this.fact = geometry.getFactory();
        if (geometry.isEmpty()) {
            return geometry;
        }
        if (geometry instanceof Point) {
            return geometry;
        }
        if (geometry instanceof MultiPoint) {
            return geometry;
        }
        if (geometry instanceof LinearRing) {
            return this.clean((LinearRing)geometry);
        }
        if (geometry instanceof LineString) {
            return this.clean((LineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.clean((Polygon)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.clean((MultiLineString)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return this.clean((MultiPolygon)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.clean((GeometryCollection)geometry);
        }
        throw new UnsupportedOperationException(geometry.getClass().getName());
    }

    private LinearRing clean(LinearRing linearRing) {
        Coordinate[] coordinateArray = CleanDuplicatePoints.removeDuplicatePoints(linearRing.getCoordinates());
        return this.fact.createLinearRing(coordinateArray);
    }

    private LineString clean(LineString lineString) {
        Coordinate[] coordinateArray = CleanDuplicatePoints.removeDuplicatePoints(lineString.getCoordinates());
        return this.fact.createLineString(coordinateArray);
    }

    private Polygon clean(Polygon polygon) {
        Coordinate[] coordinateArray = CleanDuplicatePoints.removeDuplicatePoints(polygon.getExteriorRing().getCoordinates());
        LinearRing linearRing = this.fact.createLinearRing(coordinateArray);
        ArrayList<LinearRing> arrayList = new ArrayList<LinearRing>();
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            Coordinate[] coordinateArray2 = CleanDuplicatePoints.removeDuplicatePoints(polygon.getInteriorRingN(i).getCoordinates());
            arrayList.add(this.fact.createLinearRing(coordinateArray2));
        }
        return this.fact.createPolygon(linearRing, GeometryFactory.toLinearRingArray(arrayList));
    }

    private MultiPolygon clean(MultiPolygon multiPolygon) {
        ArrayList<Polygon> arrayList = new ArrayList<Polygon>();
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            Polygon polygon = (Polygon)multiPolygon.getGeometryN(i);
            arrayList.add(this.clean(polygon));
        }
        return this.fact.createMultiPolygon(GeometryFactory.toPolygonArray(arrayList));
    }

    private MultiLineString clean(MultiLineString multiLineString) {
        ArrayList<LineString> arrayList = new ArrayList<LineString>();
        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
            LineString lineString = (LineString)multiLineString.getGeometryN(i);
            arrayList.add(this.clean(lineString));
        }
        return this.fact.createMultiLineString(GeometryFactory.toLineStringArray(arrayList));
    }

    private GeometryCollection clean(GeometryCollection geometryCollection) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            Geometry geometry = geometryCollection.getGeometryN(i);
            arrayList.add(this.clean(geometry));
        }
        return this.fact.createGeometryCollection(GeometryFactory.toGeometryArray(arrayList));
    }
}

