/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.function;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.function.GeometryFunction;
import com.vividsolutions.jtstest.util.ClassUtil;

public abstract class BaseGeometryFunction
implements GeometryFunction,
Comparable {
    protected String category = null;
    protected String name;
    protected String description;
    protected String[] parameterNames;
    protected Class[] parameterTypes;
    protected Class returnType;

    public static boolean isBinaryGeomFunction(GeometryFunction geometryFunction) {
        return geometryFunction.getParameterTypes().length >= 1 && geometryFunction.getParameterTypes()[0] == Geometry.class;
    }

    public BaseGeometryFunction(String string, String string2, String[] stringArray, Class[] classArray, Class clazz) {
        this.category = string;
        this.name = string2;
        this.parameterNames = stringArray;
        this.parameterTypes = classArray;
        this.returnType = clazz;
    }

    public BaseGeometryFunction(String string, String string2, String string3, String[] stringArray, Class[] classArray, Class clazz) {
        this.category = string;
        this.name = string2;
        this.description = string3;
        this.parameterNames = stringArray;
        this.parameterTypes = classArray;
        this.returnType = clazz;
    }

    public String getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public String getSignature() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Geometry");
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            stringBuffer.append(",");
            stringBuffer.append(ClassUtil.getClassname(this.parameterTypes[i]));
        }
        return this.name + "(" + stringBuffer + ")" + " -> " + ClassUtil.getClassname(this.returnType);
    }

    protected static Double getDoubleOrNull(Object[] objectArray, int n) {
        if (objectArray.length <= n) {
            return null;
        }
        if (objectArray[n] == null) {
            return null;
        }
        return (Double)objectArray[n];
    }

    protected static Integer getIntegerOrNull(Object[] objectArray, int n) {
        if (objectArray.length <= n) {
            return null;
        }
        if (objectArray[n] == null) {
            return null;
        }
        return (Integer)objectArray[n];
    }

    public abstract Object invoke(Geometry var1, Object[] var2);

    public boolean equals(Object object) {
        if (!(object instanceof GeometryFunction)) {
            return false;
        }
        GeometryFunction geometryFunction = (GeometryFunction)object;
        if (!this.name.equals(geometryFunction.getName())) {
            return false;
        }
        if (!this.returnType.equals(geometryFunction.getReturnType())) {
            return false;
        }
        Class[] classArray = geometryFunction.getParameterTypes();
        if (this.parameterTypes.length != classArray.length) {
            return false;
        }
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (this.parameterTypes[i].equals(classArray[i])) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object object) {
        BaseGeometryFunction baseGeometryFunction = (BaseGeometryFunction)object;
        int n = this.name.compareTo(baseGeometryFunction.getName());
        if (n != 0) {
            return n;
        }
        return BaseGeometryFunction.compareTo(this.returnType, baseGeometryFunction.getReturnType());
    }

    private static int compareTo(Class clazz, Class clazz2) {
        return clazz.getName().compareTo(clazz2.getName());
    }
}

