/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.function;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.util.GeometryMapper;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.noding.SegmentString;
import com.vividsolutions.jts.operation.buffer.BufferInputLineSimplifier;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import com.vividsolutions.jts.operation.buffer.OffsetCurveBuilder;
import com.vividsolutions.jts.operation.buffer.OffsetCurveSetBuilder;
import com.vividsolutions.jts.operation.buffer.validate.BufferResultValidator;
import java.util.ArrayList;
import java.util.List;

public class BufferFunctions {
    public static String bufferDescription = "Buffers a geometry by a distance";

    public static Geometry buffer(Geometry geometry, double d) {
        return geometry.buffer(d);
    }

    public static Geometry bufferWithParams(Geometry geometry, Double d, Integer n, Integer n2, Integer n3, Double d2) {
        double d3 = 0.0;
        if (d != null) {
            d3 = d;
        }
        BufferParameters bufferParameters = new BufferParameters();
        if (n != null) {
            bufferParameters.setQuadrantSegments(n.intValue());
        }
        if (n2 != null) {
            bufferParameters.setEndCapStyle(n2.intValue());
        }
        if (n3 != null) {
            bufferParameters.setJoinStyle(n3.intValue());
        }
        if (d2 != null) {
            bufferParameters.setMitreLimit(d2.doubleValue());
        }
        return BufferOp.bufferOp((Geometry)geometry, (double)d3, (BufferParameters)bufferParameters);
    }

    public static Geometry bufferCurve(Geometry geometry, double d) {
        return BufferFunctions.buildCurveSet(geometry, d, new BufferParameters());
    }

    public static Geometry bufferCurveWithParams(Geometry geometry, Double d, Integer n, Integer n2, Integer n3, Double d2) {
        double d3 = 0.0;
        if (d != null) {
            d3 = d;
        }
        BufferParameters bufferParameters = new BufferParameters();
        if (n != null) {
            bufferParameters.setQuadrantSegments(n.intValue());
        }
        if (n2 != null) {
            bufferParameters.setEndCapStyle(n2.intValue());
        }
        if (n3 != null) {
            bufferParameters.setJoinStyle(n3.intValue());
        }
        if (d2 != null) {
            bufferParameters.setMitreLimit(d2.doubleValue());
        }
        return BufferFunctions.buildCurveSet(geometry, d3, bufferParameters);
    }

    private static Geometry buildCurveSet(Geometry geometry, double d, BufferParameters bufferParameters) {
        OffsetCurveBuilder offsetCurveBuilder = new OffsetCurveBuilder(geometry.getFactory().getPrecisionModel(), bufferParameters);
        OffsetCurveSetBuilder offsetCurveSetBuilder = new OffsetCurveSetBuilder(geometry, d, offsetCurveBuilder);
        List list = offsetCurveSetBuilder.getCurves();
        ArrayList<LineString> arrayList = new ArrayList<LineString>();
        for (SegmentString segmentString : list) {
            Coordinate[] coordinateArray = segmentString.getCoordinates();
            arrayList.add(geometry.getFactory().createLineString(coordinateArray));
        }
        Geometry geometry2 = geometry.getFactory().buildGeometry(arrayList);
        return geometry2;
    }

    public static Geometry bufferLineSimplifier(Geometry geometry, double d) {
        return BufferFunctions.buildBufferLineSimplifiedSet(geometry, d);
    }

    private static Geometry buildBufferLineSimplifiedSet(Geometry geometry, double d) {
        ArrayList<LineString> arrayList = new ArrayList<LineString>();
        ArrayList arrayList2 = new ArrayList();
        LinearComponentExtracter.getLines((Geometry)geometry, arrayList2);
        for (LineString lineString : arrayList2) {
            Coordinate[] coordinateArray = lineString.getCoordinates();
            arrayList.add(geometry.getFactory().createLineString(BufferInputLineSimplifier.simplify((Coordinate[])coordinateArray, (double)d)));
        }
        Geometry geometry2 = geometry.getFactory().buildGeometry(arrayList);
        return geometry2;
    }

    public static Geometry bufferValidated(Geometry geometry, double d) {
        Geometry geometry2 = geometry.buffer(d);
        String string = BufferResultValidator.isValidMsg((Geometry)geometry, (double)d, (Geometry)geometry2);
        if (string != null) {
            throw new IllegalStateException("Buffer Validation error: " + string);
        }
        return geometry2;
    }

    public static Geometry bufferValidatedGeom(Geometry geometry, double d) {
        Geometry geometry2 = geometry.buffer(d);
        BufferResultValidator bufferResultValidator = new BufferResultValidator(geometry, d, geometry2);
        boolean bl = bufferResultValidator.isValid();
        return bufferResultValidator.getErrorIndicator();
    }

    public static Geometry singleSidedBufferCurve(Geometry geometry, double d) {
        BufferParameters bufferParameters = new BufferParameters();
        bufferParameters.setSingleSided(true);
        OffsetCurveBuilder offsetCurveBuilder = new OffsetCurveBuilder(geometry.getFactory().getPrecisionModel(), bufferParameters);
        Coordinate[] coordinateArray = offsetCurveBuilder.getLineCurve(geometry.getCoordinates(), d);
        LineString lineString = geometry.getFactory().createLineString(coordinateArray);
        return lineString;
    }

    public static Geometry singleSidedBuffer(Geometry geometry, double d) {
        BufferParameters bufferParameters = new BufferParameters();
        bufferParameters.setSingleSided(true);
        return BufferOp.bufferOp((Geometry)geometry, (double)d, (BufferParameters)bufferParameters);
    }

    public static Geometry bufferEach(Geometry geometry, final double d) {
        return GeometryMapper.map((Geometry)geometry, (GeometryMapper.MapOp)new GeometryMapper.MapOp(){

            public Geometry map(Geometry geometry) {
                return geometry.buffer(d);
            }
        });
    }
}

