/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.function;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Polygonal;

public class GeometryFunctions {
    public static String lengthDescription = "Computes the length of perimeter of a Geometry";

    public static double length(Geometry geometry) {
        return geometry.getLength();
    }

    public static double area(Geometry geometry) {
        return geometry.getArea();
    }

    public static boolean isCCW(Geometry geometry) {
        Coordinate[] coordinateArray = null;
        if (geometry instanceof Polygon) {
            coordinateArray = ((Polygon)geometry).getExteriorRing().getCoordinates();
        } else if (geometry instanceof LineString && ((LineString)geometry).isClosed()) {
            coordinateArray = geometry.getCoordinates();
        }
        if (coordinateArray == null) {
            return false;
        }
        return CGAlgorithms.isCCW((Coordinate[])coordinateArray);
    }

    public static boolean isSimple(Geometry geometry) {
        return geometry.isSimple();
    }

    public static boolean isValid(Geometry geometry) {
        return geometry.isValid();
    }

    public static boolean isRectangle(Geometry geometry) {
        return geometry.isRectangle();
    }

    public static boolean isClosed(Geometry geometry) {
        if (geometry instanceof LineString) {
            return ((LineString)geometry).isClosed();
        }
        if (geometry instanceof MultiLineString) {
            return ((MultiLineString)geometry).isClosed();
        }
        return true;
    }

    public static Geometry envelope(Geometry geometry) {
        return geometry.getEnvelope();
    }

    public static Geometry reverse(Geometry geometry) {
        return geometry.reverse();
    }

    public static Geometry normalize(Geometry geometry) {
        Geometry geometry2 = (Geometry)geometry.clone();
        geometry2.normalize();
        return geometry2;
    }

    public static Geometry getGeometryN(Geometry geometry, int n) {
        return geometry.getGeometryN(n);
    }

    public static Geometry getPolygonShell(Geometry geometry) {
        if (geometry instanceof Polygon) {
            LinearRing linearRing = (LinearRing)((Polygon)geometry).getExteriorRing();
            return geometry.getFactory().createPolygon(linearRing, null);
        }
        if (geometry instanceof MultiPolygon) {
            Polygon[] polygonArray = new Polygon[geometry.getNumGeometries()];
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                LinearRing linearRing = (LinearRing)((Polygon)geometry.getGeometryN(i)).getExteriorRing();
                polygonArray[i] = geometry.getFactory().createPolygon(linearRing, null);
            }
            return geometry.getFactory().createMultiPolygon(polygonArray);
        }
        return null;
    }

    public static Geometry getPolygonHoleN(Geometry geometry, int n) {
        if (geometry instanceof Polygon) {
            LinearRing linearRing = (LinearRing)((Polygon)geometry).getInteriorRingN(n);
            return linearRing;
        }
        return null;
    }

    public static Geometry convertToPolygon(Geometry geometry) {
        if (geometry instanceof Polygonal) {
            return geometry;
        }
        LinearRing linearRing = geometry.getFactory().createLinearRing(geometry.getCoordinates());
        return geometry.getFactory().createPolygon(linearRing, null);
    }

    public static Geometry getCoordinates(Geometry geometry) {
        Coordinate[] coordinateArray = geometry.getCoordinates();
        return geometry.getFactory().createMultiPoint(coordinateArray);
    }
}

