/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.function;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.noding.BasicSegmentString;
import com.vividsolutions.jts.noding.FastNodingValidator;
import com.vividsolutions.jts.noding.IntersectionAdder;
import com.vividsolutions.jts.noding.MCIndexNoder;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.Noder;
import com.vividsolutions.jts.noding.ScaledNoder;
import com.vividsolutions.jts.noding.SegmentIntersector;
import com.vividsolutions.jts.noding.SegmentString;
import com.vividsolutions.jts.noding.snapround.GeometryNoder;
import com.vividsolutions.jts.noding.snapround.MCIndexSnapRounder;
import com.vividsolutions.jts.precision.GeometryPrecisionReducer;
import com.vividsolutions.jtstest.function.FunctionsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodingFunctions {
    public static Geometry snapRoundWithPointwisePrecisionReduction(Geometry geometry, double d) {
        PrecisionModel precisionModel = new PrecisionModel(d);
        Geometry geometry2 = GeometryPrecisionReducer.reducePointwise((Geometry)geometry, (PrecisionModel)precisionModel);
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        arrayList.add(geometry2);
        GeometryNoder geometryNoder = new GeometryNoder(precisionModel);
        List list = geometryNoder.node(arrayList);
        return FunctionsUtil.getFactoryOrDefault(geometry).buildGeometry((Collection)list);
    }

    public static Geometry checkNoding(Geometry geometry) {
        List list = NodingFunctions.createSegmentStrings(geometry);
        FastNodingValidator fastNodingValidator = new FastNodingValidator((Collection)list);
        fastNodingValidator.setFindAllIntersections(true);
        fastNodingValidator.isValid();
        List list2 = fastNodingValidator.getIntersections();
        Point[] pointArray = new Point[list2.size()];
        for (int i = 0; i < list2.size(); ++i) {
            Coordinate coordinate = (Coordinate)list2.get(i);
            pointArray[i] = FunctionsUtil.getFactoryOrDefault(null).createPoint(coordinate);
        }
        return FunctionsUtil.getFactoryOrDefault(null).createMultiPoint(pointArray);
    }

    public static Geometry MCIndexNoding(Geometry geometry, double d) {
        List list = NodingFunctions.createNodedSegmentStrings(geometry);
        PrecisionModel precisionModel = new PrecisionModel(d);
        MCIndexNoder mCIndexNoder = new MCIndexNoder((SegmentIntersector)new IntersectionAdder((LineIntersector)new RobustLineIntersector()));
        mCIndexNoder.computeNodes((Collection)list);
        Collection collection = mCIndexNoder.getNodedSubstrings();
        return NodingFunctions.fromSegmentStrings(collection);
    }

    public static Geometry scaledNoding(Geometry geometry, double d) {
        List list = NodingFunctions.createSegmentStrings(geometry);
        PrecisionModel precisionModel = new PrecisionModel(d);
        ScaledNoder scaledNoder = new ScaledNoder((Noder)new MCIndexSnapRounder(new PrecisionModel(1.0)), precisionModel.getScale());
        scaledNoder.computeNodes((Collection)list);
        Collection collection = scaledNoder.getNodedSubstrings();
        return NodingFunctions.fromSegmentStrings(collection);
    }

    private static List createSegmentStrings(Geometry geometry) {
        ArrayList<BasicSegmentString> arrayList = new ArrayList<BasicSegmentString>();
        List list = LinearComponentExtracter.getLines((Geometry)geometry);
        for (LineString lineString : list) {
            arrayList.add(new BasicSegmentString(lineString.getCoordinates(), null));
        }
        return arrayList;
    }

    private static List createNodedSegmentStrings(Geometry geometry) {
        ArrayList<NodedSegmentString> arrayList = new ArrayList<NodedSegmentString>();
        List list = LinearComponentExtracter.getLines((Geometry)geometry);
        for (LineString lineString : list) {
            arrayList.add(new NodedSegmentString(lineString.getCoordinates(), null));
        }
        return arrayList;
    }

    private static Geometry fromSegmentStrings(Collection collection) {
        LineString[] lineStringArray = new LineString[collection.size()];
        int n = 0;
        for (SegmentString segmentString : collection) {
            LineString lineString = FunctionsUtil.getFactoryOrDefault(null).createLineString(segmentString.getCoordinates());
            lineStringArray[n++] = lineString;
        }
        return FunctionsUtil.getFactoryOrDefault(null).createMultiLineString(lineStringArray);
    }
}

